/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.gui.dynamic;

import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.panels.PathSelectionPanel;
import com.izforge.izpack.util.Debug;
import com.redhat.installer.gui.dynamic.DynamicValidator;
import com.redhat.installer.gui.dynamic.KeyValueDynamicComponent;
import com.redhat.installer.gui.dynamic.SecurityDomainModule;
import com.redhat.installer.gui.dynamic.TwoJTextFieldJPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DynamicComponentsPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -998206641413808493L;
    private static final String addOneCommand = "AddOne";
    private static final String removeOneCommand = "RemoveOne";
    private static final String TwoJTextFieldJPanel = "com.izforge.izpack.gui.dynamic.TwoJTextFieldJPanel";
    private final Class<?> dynamicComponentType;
    private int dynamicComponentCount = 0;
    private int minDynamicComponents;
    private final int maxDynamicComponents;
    private final JLabel addDynamicLabel;
    private final JButton addDynamicComponentButton;
    private final JButton removeDynamicComponentButton;
    private boolean enabled = true;
    private InstallData idata;
    private IzPanel izpanel;
    private String tooltip;
    private JPanel dynamicComponents;
    private String[][] defaults = null;
    private String id = null;

    public DynamicComponentsPanel(Class<?> type, int maxComponents, int minComponents, JComponent headerComponent) {
        super(true);
        JLabel addLabel;
        GridBagLayout layout = new GridBagLayout();
        layout.rowHeights = new int[]{0, 0, 0};
        layout.columnWidths = new int[]{0};
        layout.columnWeights = new double[]{1.0};
        layout.rowWeights = new double[]{0.0, 1.0, 0.0};
        super.setLayout(layout);
        super.setOpaque(false);
        if (type == JLabel.class || type == JButton.class) {
            throw new RuntimeException("JComponents of the implementing class " + type.getCanonicalName() + " aren't accepted as the dynamic component type.");
        }
        if (!JComponent.class.isAssignableFrom(type)) {
            throw new RuntimeException("Class " + type.getCanonicalName() + " isn't JComponent or a subclass of JComponent");
        }
        this.dynamicComponentType = type;
        if (maxComponents <= 0) {
            throw new RuntimeException("Maxiumum components limit of " + maxComponents + " is not valid (must be > 0)");
        }
        this.maxDynamicComponents = maxComponents;
        this.minDynamicComponents = minComponents < 0 ? 0 : minComponents;
        JPanel addRemovePanel = new JPanel(new GridLayout(1, 2));
        JButton addButton = new JButton("+1");
        addButton.setActionCommand(addOneCommand);
        addButton.addActionListener(this);
        addRemovePanel.add(addButton);
        this.addDynamicComponentButton = addButton;
        JButton removeButton = new JButton("-1");
        removeButton.setActionCommand(removeOneCommand);
        removeButton.addActionListener(this);
        removeButton.setEnabled(false);
        addRemovePanel.add(removeButton);
        this.removeDynamicComponentButton = removeButton;
        this.addDynamicLabel = addLabel = new JLabel();
        this.dynamicComponents = new JPanel(new GridLayout(0, 1), true);
        GridBagConstraints gbc_headerComponent = new GridBagConstraints();
        gbc_headerComponent.fill = 2;
        gbc_headerComponent.anchor = 17;
        gbc_headerComponent.gridx = 0;
        gbc_headerComponent.gridy = 0;
        GridBagConstraints gbc_dynamicComponents = new GridBagConstraints();
        gbc_dynamicComponents.fill = 1;
        gbc_dynamicComponents.anchor = 10;
        gbc_dynamicComponents.gridx = 0;
        gbc_dynamicComponents.gridy = 1;
        GridBagConstraints gbc_addRemovePanel = new GridBagConstraints();
        gbc_addRemovePanel.fill = 0;
        gbc_addRemovePanel.anchor = 13;
        gbc_addRemovePanel.gridx = 0;
        gbc_addRemovePanel.gridy = 2;
        super.add((Component)headerComponent, gbc_headerComponent);
        super.add((Component)this.dynamicComponents, gbc_dynamicComponents);
        if (maxComponents > 1) {
            super.add((Component)addRemovePanel, gbc_addRemovePanel);
        }
    }

    public DynamicComponentsPanel(Class<?> type, int maxComponents, int minComponents, JComponent headerComponent, String tooltip) {
        this(type, maxComponents, minComponents, headerComponent);
        this.setTooltip(tooltip);
    }

    public DynamicComponentsPanel(Class<?> type, int maxComponents, int minComponents, String tooltip) {
        this(type, maxComponents, minComponents, new JPanel(new GridLayout(1, 2)));
        this.setTooltip(tooltip);
    }

    public void setIdata(InstallData idata) {
        this.idata = idata;
    }

    public void setIzpanel(IzPanel parent) {
        this.izpanel = parent;
    }

    public Map<String, String> serialize(String namePrefix) {
        LinkedHashMap<String, String> serialisedData = new LinkedHashMap<String, String>();
        Component[] components = this.dynamicComponents.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (!component.isEnabled()) {
                Debug.log("DUDE COMPONENT NOT ENABLED");
            }
            if (KeyValueDynamicComponent.class.isAssignableFrom(component.getClass())) {
                KeyValueDynamicComponent keyValueComponent = (KeyValueDynamicComponent)((Object)component);
                String name = keyValueComponent.getKey();
                String value = keyValueComponent.getValue();
                serialisedData.put(namePrefix + "-" + (i + 1) + "-name", name);
                serialisedData.put(namePrefix + "-" + (i + 1) + "-value", value);
                continue;
            }
            if (PathSelectionPanel.class.isAssignableFrom(component.getClass())) {
                PathSelectionPanel pathSelectionComponent = (PathSelectionPanel)component;
                String path = pathSelectionComponent.getPath();
                serialisedData.put(namePrefix + "-" + (i + 1) + "-path", path);
                continue;
            }
            if (SecurityDomainModule.class.isAssignableFrom(component.getClass())) {
                String operationValidator = "([^ ,=]+=[^, =]+)(,[^ ,=]+=[^, =]+)*";
                SecurityDomainModule securityDomainModule = (SecurityDomainModule)component;
                if (!Pattern.matches(operationValidator, securityDomainModule.getOperation())) {
                    return null;
                }
                serialisedData.put(namePrefix + ".left." + i, securityDomainModule.getCode());
                serialisedData.put(namePrefix + ".middle." + i, securityDomainModule.getFlag());
                serialisedData.put(namePrefix + ".right." + i, securityDomainModule.getOperation());
                continue;
            }
            throw new RuntimeException("Unhandled component type " + component.getClass().getCanonicalName() + "at index " + i);
        }
        return serialisedData;
    }

    public boolean noKeyDuplication() {
        Component[] components = this.dynamicComponents.getComponents();
        LinkedHashMap<String, String> componentMap = new LinkedHashMap<String, String>();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (KeyValueDynamicComponent.class.isAssignableFrom(component.getClass())) {
                KeyValueDynamicComponent kvComponent = (KeyValueDynamicComponent)((Object)component);
                if (componentMap.containsKey(kvComponent.getKey())) {
                    return false;
                }
                componentMap.put(kvComponent.getKey(), kvComponent.getValue());
                continue;
            }
            if (!PathSelectionPanel.class.isAssignableFrom(component.getClass())) continue;
            PathSelectionPanel psPanel = (PathSelectionPanel)component;
            if (componentMap.containsKey(psPanel.getPath())) {
                return false;
            }
            componentMap.put(psPanel.getPath(), "");
        }
        return true;
    }

    public boolean noEmptyProperties() {
        Component[] components = this.dynamicComponents.getComponents();
        for (int i = 2; i < components.length; ++i) {
            KeyValueDynamicComponent kvComponent;
            Component component = components[i];
            if (!KeyValueDynamicComponent.class.isAssignableFrom(component.getClass()) || !(kvComponent = (KeyValueDynamicComponent)((Object)component)).getKey().equals("") && !kvComponent.getValue().equals("")) continue;
            return false;
        }
        return true;
    }

    public boolean validateDynamicComponents(DynamicValidator validator) {
        Component[] components = this.dynamicComponents.getComponents();
        for (int i = 0; i < components.length; ++i) {
            KeyValueDynamicComponent kvComponent;
            Component component = components[i];
            if (!KeyValueDynamicComponent.class.isAssignableFrom(component.getClass()) || validator.validateData((kvComponent = (KeyValueDynamicComponent)((Object)component)).getKey(), kvComponent.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean somethingChanged = false;
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals(addOneCommand)) {
            this.oneMore();
            somethingChanged = true;
        } else if (actionCommand.equals(removeOneCommand)) {
            this.oneLess();
            somethingChanged = true;
        }
        if (somethingChanged) {
            this.refresh();
        }
    }

    private void refresh() {
        super.revalidate();
        super.repaint();
    }

    public void setAddButtonText(String text) {
        this.addDynamicComponentButton.setText(text);
        this.refresh();
    }

    public void setRemoveButtonText(String text) {
        this.removeDynamicComponentButton.setText(text);
        this.refresh();
    }

    public void setAddLabel() {
        this.addDynamicLabel.setText("Test");
        this.refresh();
    }

    public void addInitial() {
        this.addInitial(new ArrayList<String>());
    }

    public void addInitial(ArrayList<String> defaultValues) {
        this.addInitial(defaultValues, true);
    }

    public void addInitial(ArrayList<String> defaultValues, boolean enabled) {
        if (defaultValues.isEmpty() || defaultValues == null) {
            this.oneMore();
        } else {
            for (String defaultValue : defaultValues) {
                this.oneMore(defaultValue, enabled);
            }
        }
        this.refresh();
    }

    public void initializeDefaults(String[][] elements) {
        this.dynamicComponentCount += elements.length;
        this.defaults = elements;
        Object object = this.createUnknownObject();
        JPanel component = null;
        for (String[] keyValue : elements) {
            if (this.isJTwoTextField(object)) {
                component = new TwoJTextFieldJPanel(keyValue[0], keyValue[1]);
            } else if (this.isSecurityDomainModule(object)) {
                component = new SecurityDomainModule(keyValue[0], keyValue[1]);
            }
            if (component == null) continue;
            this.dynamicComponents.add(component);
        }
    }

    private void oneMore() {
        this.oneMore("");
    }

    private void oneMore(String defaultValue) {
        this.oneMore(defaultValue, true);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void oneMore(String defaultValue, boolean isEnabled) {
        void var4_9;
        Object object = this.createUnknownObject();
        Object var4_4 = null;
        if (this.isSecurityDomainModule(object)) {
            SecurityDomainModule securityDomainModule = new SecurityDomainModule(this.id);
        } else if (this.isJTwoTextField(object)) {
            TwoJTextFieldJPanel temp = (TwoJTextFieldJPanel)object;
            if (this.tooltip != null) {
                temp.getKeyField().setToolTipText(this.tooltip);
                temp.getValueField().setToolTipText(this.tooltip);
            }
            TwoJTextFieldJPanel twoJTextFieldJPanel = temp;
        } else if (this.isPathSelectionPanel(object)) {
            if (this.idata == null || this.izpanel == null) throw new RuntimeException("Missing required izpanel and idata information for PathSelectionPanel" + this.dynamicComponentType);
            PathSelectionPanel temp = (PathSelectionPanel)object;
            temp.setIdata(this.idata);
            temp.setIzPanel(this.izpanel);
            temp.createLayout();
            temp.setEnabled(isEnabled);
            if (defaultValue != null & !defaultValue.isEmpty()) {
                temp.setPath(defaultValue);
            }
            if (this.tooltip != null) {
                temp.getPathInputField().setToolTipText(this.tooltip);
            }
            PathSelectionPanel pathSelectionPanel = temp;
        } else {
            JComponent jComponent = (JComponent)object;
        }
        this.dynamicComponents.add((Component)var4_9);
        ++this.dynamicComponentCount;
        if (this.dynamicComponentCount >= this.maxDynamicComponents) {
            this.addDynamicComponentButton.setEnabled(false);
            return;
        } else {
            if (this.dynamicComponentCount <= this.minDynamicComponents) return;
            this.removeDynamicComponentButton.setEnabled(true);
        }
    }

    private void oneLess() {
        this.dynamicComponents.remove(this.dynamicComponents.getComponentCount() - 1);
        --this.dynamicComponentCount;
        if (this.defaults != null && this.dynamicComponentCount <= this.defaults.length) {
            this.removeDynamicComponentButton.setEnabled(false);
        } else if (this.dynamicComponentCount <= 1) {
            this.removeDynamicComponentButton.setEnabled(false);
        } else if (this.dynamicComponentCount < this.maxDynamicComponents) {
            this.addDynamicComponentButton.setEnabled(true);
        }
    }

    public void clearDynamicComponents() {
        for (int i = this.dynamicComponentCount; i > 0; --i) {
            this.oneLess();
        }
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public boolean isJTwoTextField(Object obj) {
        return JComponent.class.isAssignableFrom(obj.getClass()) && TwoJTextFieldJPanel.class.isAssignableFrom(obj.getClass());
    }

    public boolean isPathSelectionPanel(Object obj) {
        return JComponent.class.isAssignableFrom(obj.getClass()) && PathSelectionPanel.class.isAssignableFrom(obj.getClass());
    }

    public boolean isSecurityDomainModule(Object obj) {
        return JComponent.class.isAssignableFrom(obj.getClass()) && SecurityDomainModule.class.isAssignableFrom(obj.getClass());
    }

    private Object createUnknownObject() {
        try {
            return this.dynamicComponentType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Could not get instance for contained component type", e);
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void hideButtons() {
        this.addDynamicComponentButton.setVisible(false);
        this.removeDynamicComponentButton.setVisible(false);
    }

    public void showButtons() {
        this.addDynamicComponentButton.setVisible(true);
        this.removeDynamicComponentButton.setVisible(true);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        Component[] components = this.dynamicComponents.getComponents();
        for (int i = 0; i < components.length; ++i) {
            components[i].setEnabled(enabled);
        }
        this.addDynamicComponentButton.setEnabled(enabled);
        this.removeDynamicComponentButton.setEnabled(enabled && this.dynamicComponentCount > this.minDynamicComponents);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

