/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.installation.action;

import com.izforge.izpack.event.SimpleInstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.Unpacker;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.CleanupClient;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class AbortedInstallationCleanUp
extends SimpleInstallerListener
implements CleanupClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void cleanUp() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String aborted = idata.getVariable("install.aborted");
        String installPath = idata.getVariable("INSTALL_PATH") + File.separator;
        File installFolder = new File(installPath);
        if (aborted == null || !Boolean.parseBoolean(aborted)) return;
        if (!Unpacker.interruptAll(40000L)) {
            return;
        }
        try {
            idata.uninstallOutJar.close();
            FileUtils.deleteDirectory(installFolder);
            if (!installFolder.exists()) return;
        }
        catch (IOException iOException) {
            if (!installFolder.exists()) return;
            System.out.println(String.format(idata.langpack.getString("abortedinstallationcleanup.failure"), installPath));
            System.out.println(idata.langpack.getString("abortedinstallationcleanup.warning"));
            return;
            catch (Throwable throwable) {
                if (!installFolder.exists()) throw throwable;
                System.out.println(String.format(idata.langpack.getString("abortedinstallationcleanup.failure"), installPath));
                System.out.println(idata.langpack.getString("abortedinstallationcleanup.warning"));
                throw throwable;
            }
        }
        System.out.println(String.format(idata.langpack.getString("abortedinstallationcleanup.failure"), installPath));
        System.out.println(idata.langpack.getString("abortedinstallationcleanup.warning"));
        return;
    }

    @Override
    public void beforePacks(AutomatedInstallData idata, Integer npacks, AbstractUIProgressHandler handler) throws Exception {
        Debug.log("Registering AbortedInstallationCleanup for Cleanup.");
        Housekeeper.getInstance().registerForCleanup(this);
    }
}

