/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.installation.action;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionConfiguration;
import com.izforge.izpack.util.AbstractUIHandler;
import com.redhat.installer.ports.utils.PortOffset;
import java.util.HashMap;
import java.util.Map;

public class ShortcutHelper
implements PanelAction {
    private static final String STANDALONE_MANAGEMENT_HTTP_KEY = "standalone.xml.management-http";
    private static final String STANDALONE_MANAGEMENT_HTTPS_KEY = "standalone.xml.management-https";
    private static final String DOMAIN_MANAGEMENT_HTTP_KEY = "host.management-http";
    private static final String DOMAIN_MANAGEMENT_HTTPS_KEY = "domain.default.management-https-2";
    private static final String STANDALONE_SHORTCUT_KEY = "standalone.shortcut.port";
    private static final String DOMAIN_SHORTCUT_KEY = "domain.shortcut.port";
    private static final String URL_PROTOCOL_KEY = "url.protocol";
    private Map<String, String> portMap = new HashMap<String, String>();
    private static final String SSL_CONDITION = "install.ssl";
    private AutomatedInstallData idata;

    @Override
    public void executeAction(AutomatedInstallData idata, AbstractUIHandler handler) {
        this.idata = idata;
        this.fillPortMap();
        this.applyOffset();
        this.applySSL();
    }

    private void fillPortMap() {
        this.portMap.put(STANDALONE_MANAGEMENT_HTTP_KEY, null);
        this.portMap.put(STANDALONE_MANAGEMENT_HTTPS_KEY, null);
        this.portMap.put(DOMAIN_MANAGEMENT_HTTP_KEY, null);
        this.portMap.put(DOMAIN_MANAGEMENT_HTTPS_KEY, null);
    }

    private void applyOffset() {
        int portOffset = PortOffset.get();
        this.portMap.replaceAll((k, v) -> {
            int portNumber = this.getNumber(this.getPortNumber(this.idata.getVariable((String)k)));
            return String.valueOf(portNumber += portOffset);
        });
    }

    private void applySSL() {
        boolean useSSL = this.idata.getRules().isConditionTrue(SSL_CONDITION);
        String standalonePort = useSSL ? this.portMap.get(STANDALONE_MANAGEMENT_HTTPS_KEY) : this.portMap.get(STANDALONE_MANAGEMENT_HTTP_KEY);
        String domainPort = useSSL ? this.portMap.get(DOMAIN_MANAGEMENT_HTTPS_KEY) : this.portMap.get(DOMAIN_MANAGEMENT_HTTP_KEY);
        this.idata.setVariable(STANDALONE_SHORTCUT_KEY, standalonePort);
        this.idata.setVariable(DOMAIN_SHORTCUT_KEY, domainPort);
        if (useSSL) {
            this.idata.setVariable(URL_PROTOCOL_KEY, "https");
        }
    }

    private int getNumber(String number) {
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private String getPortNumber(String portData) {
        if (portData.startsWith("$") && portData.contains(":") && portData.endsWith("}")) {
            return portData.substring(portData.indexOf(":") + 1, portData.indexOf("}"));
        }
        return portData;
    }

    @Override
    public void initialize(PanelActionConfiguration configuration) {
    }
}

