/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.installation.maven.processpanel;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.constants.GeneralConstants;
import com.redhat.installer.installation.processpanel.ArgumentParser;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.InputMismatchException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MavenSettingsTransformer
implements GeneralConstants {
    private static ArgumentParser parser;
    private static AutomatedInstallData idata;
    private static AbstractUIProcessHandler mHandler;
    private static final String ACTIVE_PROFILES = "activeProfiles";
    private static final String ACTIVE_PROFILE = "activeProfile";
    private static final String PROFILE = "profile";
    private static final String PROFILES = "profiles";
    private static final String REPOSITORIES = "repositories";
    private static final String REPOSITORY = "repository";
    private static final String PLUGIN_REPOSITORIES = "pluginRepositories";
    private static final String PLUGIN_REPOSITORY = "pluginRepository";
    private static final String ID = "id";
    private static final String URL = "url";
    private static final String SETTINGS = "settings";
    private static final String NAME = "name";
    private static final String LAYOUT = "layout";
    private static final String RELEASES = "releases";
    private static final String UPDATE_POLICY = "updatePolicy";
    private static final String SNAPSHOTS = "snapshots";
    private static final String ENABLED = "enabled";
    private static final String LOCAL_REPOSTIROY = "localRepository";
    private static final String SETTINGS_FILE = "settings-file";
    private static final String INSTALLER = "installer";
    private static final String PROFILE_ARG = "profile";

    public static void run(AbstractUIProcessHandler handler, String[] args) throws Exception {
        mHandler = handler;
        parser = new ArgumentParser();
        idata = AutomatedInstallData.getInstance();
        parser.parse(args);
        String settingsPath = parser.getStringProperty(SETTINGS_FILE);
        String installer = parser.getStringProperty(INSTALLER);
        String profileName = parser.getStringProperty("profile");
        File settingsFile = new File(settingsPath);
        if (!settingsFile.exists() || settingsFile.length() == 0L) {
            MavenSettingsTransformer.createDefaultSettingsXml(settingsPath);
        } else {
            FileUtils.copyFile(settingsFile, new File(settingsFile.getPath() + ".jboss_backup"));
        }
        MavenSettingsTransformer.readAndModifySettingsXml(settingsPath, installer, profileName);
    }

    private static void readAndModifySettingsXml(String fileName, String installer, String profileName) {
        File settingsFile = new File(fileName);
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbFactory.newDocumentBuilder();
            Document doc = builder.parse(settingsFile);
            ArrayList<HashMap<String, String>> profileData = new ArrayList<HashMap<String, String>>();
            ArrayList<String> existingIds = new ArrayList<String>();
            ArrayList<String> missingUrls = new ArrayList<String>();
            String url = "";
            if (installer.equals("eap")) {
                url = idata.getVariable("MAVEN_REPO_PATH");
                missingUrls.add(url);
                profileData.add(MavenSettingsTransformer.genMap(profileName, profileName + "-repository", profileName + "-plugin-repository", "JBoss GA Tech Preview Maven Repository", "JBoss 7 Maven Plugin Repository", idata.getVariable("MAVEN_REPO_PATH"), "never", "default"));
            } else {
                url = "http://maven.repository.redhat.com/techpreview/all/";
                missingUrls.add(url);
                profileData.add(MavenSettingsTransformer.genMap(profileName, profileName, profileName, "Red Hat Tech Preview repository (all)", "Red Hat Tech Preview repository (all)", "http://maven.repository.redhat.com/techpreview/all/", "never", "default"));
            }
            missingUrls = MavenSettingsTransformer.findMissingUrls(doc, missingUrls);
            if (missingUrls.isEmpty()) {
                ProcessPanelHelper.printToPanel(mHandler, String.format(MavenSettingsTransformer.idata.langpack.getString("MavenRepoCheckPanel.settings.urls.exist"), settingsFile, url), false);
                return;
            }
            NodeList nodeList = doc.getElementsByTagName(ID);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element e = (Element)nodeList.item(i);
                existingIds.add(e.getTextContent());
            }
            Element root = (Element)doc.getElementsByTagName(SETTINGS).item(0);
            Element profiles = (Element)doc.getElementsByTagName(PROFILES).item(0);
            Element actives = (Element)doc.getElementsByTagName(ACTIVE_PROFILES).item(0);
            if (profiles == null) {
                profiles = doc.createElement(PROFILES);
                root.appendChild(profiles);
            }
            if (actives == null) {
                actives = doc.createElement(ACTIVE_PROFILES);
                root.appendChild(actives);
            }
            String profileId = "";
            for (Map map : profileData) {
                if (!missingUrls.contains(map.get(URL))) continue;
                if (existingIds.contains(map.get("profileId"))) {
                    map.put("profileId", (String)map.get("profileId") + "-" + System.currentTimeMillis());
                }
                profileId = (String)map.get("profileId");
                Element newProfile = MavenSettingsTransformer.generateProfile(doc, profileId, (String)map.get("repoId"), (String)map.get("pluginId"), (String)map.get("repoName"), (String)map.get("pluginName"), (String)map.get(URL), (String)map.get(UPDATE_POLICY), (String)map.get(LAYOUT));
                profiles.appendChild(newProfile);
                Element newActive = doc.createElement(ACTIVE_PROFILE);
                newActive.setTextContent((String)map.get("profileId"));
                actives.appendChild(newActive);
            }
            MavenSettingsTransformer.writeToFile(doc, settingsFile);
            ProcessPanelHelper.printToPanel(mHandler, String.format(MavenSettingsTransformer.idata.langpack.getString("MavenSettingsTransformer.profile.creation"), profileId, settingsFile), false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Element generateProfile(Document doc, String profileId, String repositoryId, String pluginId, String repositoryName, String pluginName, String repositoryUrl, String updatePolicy, String layout) {
        Element newProfile = doc.createElement("profile");
        Element id = doc.createElement(ID);
        id.setTextContent(profileId);
        Element repos = doc.createElement(REPOSITORIES);
        Element repo = doc.createElement(REPOSITORY);
        Element repoId = doc.createElement(ID);
        repoId.setTextContent(repositoryId);
        Element repoName = doc.createElement(NAME);
        repoName.setTextContent(repositoryName);
        Element repoUrl = doc.createElement(URL);
        repoUrl.setTextContent(repositoryUrl);
        Element repoLayout = doc.createElement(LAYOUT);
        repoLayout.setTextContent(layout);
        Element repoReleases = doc.createElement(RELEASES);
        Element repoRelEnabled = doc.createElement(ENABLED);
        repoRelEnabled.setTextContent("true");
        Element releasePolicy = doc.createElement(UPDATE_POLICY);
        releasePolicy.setTextContent(updatePolicy);
        Element repoSnapshots = doc.createElement(SNAPSHOTS);
        Element repoSnapEnabled = doc.createElement(ENABLED);
        repoSnapEnabled.setTextContent("false");
        Element snapshotPolicy = doc.createElement(UPDATE_POLICY);
        snapshotPolicy.setTextContent(updatePolicy);
        repoSnapshots.appendChild(repoSnapEnabled);
        repoSnapshots.appendChild(snapshotPolicy);
        repoReleases.appendChild(repoRelEnabled);
        repoReleases.appendChild(releasePolicy);
        repo.appendChild(repoId);
        repo.appendChild(repoName);
        repo.appendChild(repoUrl);
        repo.appendChild(repoLayout);
        repo.appendChild(repoReleases);
        repo.appendChild(repoSnapshots);
        repos.appendChild(repo);
        Element pluginRepos = doc.createElement(PLUGIN_REPOSITORIES);
        Element pluginRepo = doc.createElement(PLUGIN_REPOSITORY);
        Element pluginRepoId = doc.createElement(ID);
        pluginRepoId.setTextContent(pluginId);
        Element pluginRepoName = doc.createElement(NAME);
        pluginRepoName.setTextContent(pluginName);
        Element pluginRepoUrl = doc.createElement(URL);
        pluginRepoUrl.setTextContent(repositoryUrl);
        Element pluginLayout = doc.createElement(LAYOUT);
        pluginLayout.setTextContent(layout);
        Element pluginRepoReleases = doc.createElement(RELEASES);
        Element pluginRepoRelEnabled = doc.createElement(ENABLED);
        pluginRepoRelEnabled.setTextContent("true");
        Element pluginReleasePolicy = doc.createElement(UPDATE_POLICY);
        pluginReleasePolicy.setTextContent(updatePolicy);
        Element pluginRepoSnapshots = doc.createElement(SNAPSHOTS);
        Element pluginRepoSnapEnabled = doc.createElement(ENABLED);
        pluginRepoSnapEnabled.setTextContent("false");
        Element pluginSnapshotPolicy = doc.createElement(UPDATE_POLICY);
        pluginSnapshotPolicy.setTextContent(updatePolicy);
        pluginRepoSnapshots.appendChild(pluginRepoSnapEnabled);
        pluginRepoSnapshots.appendChild(pluginSnapshotPolicy);
        pluginRepoReleases.appendChild(pluginRepoRelEnabled);
        pluginRepoReleases.appendChild(pluginReleasePolicy);
        pluginRepo.appendChild(pluginRepoId);
        pluginRepo.appendChild(pluginRepoName);
        pluginRepo.appendChild(pluginRepoUrl);
        pluginRepo.appendChild(pluginLayout);
        pluginRepo.appendChild(pluginRepoReleases);
        pluginRepo.appendChild(pluginRepoSnapshots);
        pluginRepos.appendChild(pluginRepo);
        newProfile.appendChild(id);
        newProfile.appendChild(repos);
        newProfile.appendChild(pluginRepos);
        return newProfile;
    }

    private static void makeBackup(String pathToFile) {
        File settings = new File(pathToFile);
        File backup = new File(settings.getPath() + ".jboss_backup");
        try {
            int len;
            FileInputStream in = new FileInputStream(settings);
            FileOutputStream out = new FileOutputStream(backup);
            byte[] buffer = new byte[1024];
            while ((len = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void createDefaultSettingsXml(String settingsPath) {
        File defaultSettings = new File(settingsPath);
        defaultSettings.getParentFile().mkdirs();
        boolean successful = true;
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element root = doc.createElement(SETTINGS);
            Attr xmlns = doc.createAttribute("xmlns");
            xmlns.setValue("http://maven.apache.org/SETTINGS/1.0.0");
            Attr xmlnsXsi = doc.createAttribute("xmlns:xsi");
            xmlnsXsi.setValue("http://www.w3.org/2001/XMLSchema-instance");
            Attr xsiLoc = doc.createAttribute("xsi:schemaLocation");
            xsiLoc.setValue("http://maven.apache.org/SETTINGS/1.0.0 http://maven.apache.org/xsd/settings-1.0.0.xsd");
            root.setAttributeNode(xmlns);
            root.setAttributeNode(xmlnsXsi);
            root.setAttributeNode(xsiLoc);
            doc.appendChild(root);
            Element localRepo = doc.createElement(LOCAL_REPOSTIROY);
            root.appendChild(localRepo);
            Element profiles = doc.createElement(PROFILES);
            root.appendChild(profiles);
            Element activeProfiles = doc.createElement(ACTIVE_PROFILES);
            root.appendChild(activeProfiles);
            MavenSettingsTransformer.writeToFile(doc, defaultSettings);
        }
        catch (Exception e) {
            successful = false;
            e.printStackTrace();
        }
        if (!successful) {
            ProcessPanelHelper.printToPanel(mHandler, MavenSettingsTransformer.idata.langpack.getString("MavenRepoCheckPanel.xslt.default.failure"), true);
        } else {
            UninstallData.getInstance().addFile(settingsPath, true);
            ProcessPanelHelper.printToPanel(mHandler, String.format(MavenSettingsTransformer.idata.langpack.getString("MavenRepoCheckPanel.xslt.default.success"), settingsPath), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(Document doc, File file) {
        BufferedWriter writeOut = null;
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 4);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new StringWriter());
            transformer.transform(source, result);
            String outputString = result.getWriter().toString();
            writeOut = new BufferedWriter(new FileWriter(file));
            writeOut.write(outputString);
            writeOut.close();
        }
        catch (IOException | TransformerException e) {
            e.printStackTrace();
        }
        finally {
            if (writeOut != null) {
                try {
                    writeOut.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static HashMap<String, String> genMap(String ... data) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        String[] keys = new String[]{"profileId", "repoId", "pluginId", "repoName", "pluginName", URL, UPDATE_POLICY, LAYOUT};
        if (data.length != keys.length) {
            throw new InputMismatchException("Number of arguments don't match the length of the key array");
        }
        for (int i = 0; i < keys.length; ++i) {
            dataMap.put(keys[i], data[i]);
        }
        return dataMap;
    }

    private static ArrayList<String> findMissingUrls(Document doc, ArrayList<String> urls) {
        ArrayList<String> activeProfiles = new ArrayList<String>();
        NodeList activeProfileList = doc.getElementsByTagName(ACTIVE_PROFILES);
        for (int i = 0; i < activeProfileList.getLength(); ++i) {
            Element p = (Element)activeProfileList.item(i);
            NodeList activeList = p.getElementsByTagName(ACTIVE_PROFILE);
            for (int j = 0; j < activeList.getLength(); ++j) {
                Element a = (Element)activeList.item(j);
                activeProfiles.add(a.getTextContent());
            }
        }
        NodeList profileList = doc.getElementsByTagName("profile");
        for (int i = 0; i < profileList.getLength(); ++i) {
            NodeList pluginRepoList;
            Element pluginRepoElement;
            NodeList pluginList;
            NodeList repoList;
            String url = "";
            Element p = (Element)profileList.item(i);
            String profile = p.getElementsByTagName(ID).item(0).getTextContent();
            NodeList reposList = p.getElementsByTagName(REPOSITORIES);
            Element repoElement = (Element)reposList.item(0);
            NodeList nodeList = repoList = repoElement != null ? repoElement.getElementsByTagName(REPOSITORY) : null;
            if (repoList != null) {
                for (int j = 0; j < repoList.getLength(); ++j) {
                    Element repoElem = (Element)repoList.item(j);
                    String repo = repoElem.getElementsByTagName(URL).item(0).getTextContent();
                    if (!urls.contains(repo)) continue;
                    url = repo;
                }
            }
            NodeList nodeList2 = pluginList = (pluginRepoElement = (Element)(pluginRepoList = p.getElementsByTagName(PLUGIN_REPOSITORIES)).item(0)) != null ? pluginRepoElement.getElementsByTagName(PLUGIN_REPOSITORY) : null;
            if (pluginList == null) continue;
            for (int j = 0; j < pluginList.getLength(); ++j) {
                Element pluginElem = (Element)pluginList.item(j);
                String pluginRepo = pluginElem.getElementsByTagName(URL).item(0).getTextContent();
                if (!url.equals(pluginRepo) || !activeProfiles.contains(profile)) continue;
                urls.remove(url);
            }
        }
        return urls;
    }
}

