/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.installation.maven.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.File;

public class MavenRepositoryValidator
implements DataValidator {
    private String[] supportedProtocols = new String[]{"http", "https", "ftp"};
    private AutomatedInstallData idata;
    private String errorMessageId;
    private String formattedMessage;
    private String warningMessageId;

    @Override
    public DataValidator.Status validateData(AutomatedInstallData adata) {
        this.idata = adata;
        return this.setMavenRepository();
    }

    private DataValidator.Status setMavenRepository() {
        VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
        boolean useDefault = Boolean.parseBoolean(this.idata.getVariable("useDefaultMavenRepoLocation"));
        if (useDefault) {
            this.idata.setVariable("MAVEN_REPO_PATH", vs.substitute(this.idata.getVariable("MAVEN_REPO_PATH.default")));
            return DataValidator.Status.OK;
        }
        return this.setUserSpecifiedRepository();
    }

    private DataValidator.Status setUserSpecifiedRepository() {
        String urlType = "";
        String currentPath = this.idata.getVariable("MAVEN_REPO_PATH");
        if (this.isSupportedProtocol(currentPath)) {
            if (!IoHelper.remoteFileExists(currentPath)) {
                this.setErrorAndMessage("MavenRepoCheckPanel.path.error", new String[0]);
                return DataValidator.Status.ERROR;
            }
        } else {
            File chosenRepo;
            if (currentPath.startsWith("file://")) {
                currentPath = currentPath.substring(7);
            }
            if (!(chosenRepo = new File(currentPath)).exists() || !chosenRepo.isDirectory()) {
                this.setErrorAndMessage("MavenRepoCheckPanel.path.error", new String[0]);
                return DataValidator.Status.ERROR;
            }
            urlType = "file://";
        }
        this.idata.setVariable("MAVEN_REPO_PATH", urlType + currentPath);
        return DataValidator.Status.OK;
    }

    private boolean isSupportedProtocol(String currentPath) {
        for (String protocol : this.supportedProtocols) {
            if (!currentPath.startsWith(protocol)) continue;
            return true;
        }
        return false;
    }

    private void setErrorAndMessage(String error, String ... format) {
        this.errorMessageId = error;
        this.formattedMessage = String.format(this.idata.langpack.getString(error), format);
    }

    @Override
    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    @Override
    public String getWarningMessageId() {
        return this.errorMessageId;
    }

    @Override
    public boolean getDefaultAnswer() {
        return true;
    }

    @Override
    public String getFormattedMessage() {
        return this.formattedMessage;
    }
}

