/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.installation.maven.validator;

import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class MavenSchemaValidator
implements com.izforge.izpack.panels.Validator {
    private String mavenSettingsVersion = "1.0.0";
    private String mavenSettingsXSD = "http://maven.apache.org/xsd/settings-" + this.mavenSettingsVersion + ".xsd";

    @Override
    public Validator.Status validate(ProcessingClient client) {
        String userSettings;
        File settingsFile;
        Validator.Status failureStatus = Validator.Status.ERROR;
        if (client.hasParams() && Boolean.parseBoolean(client.getValidatorParams().get("warning"))) {
            failureStatus = Validator.Status.WARNING;
        }
        if (!(settingsFile = new File(userSettings = client.getText())).exists() || settingsFile.isDirectory() || settingsFile.length() == 0L) {
            return Validator.Status.OK;
        }
        if (this.isValidXml(settingsFile) && this.determineSettingsVersion(settingsFile)) {
            Validator.Status validationResult = settingsFile.canWrite() && this.isSchemaValid(settingsFile) ? Validator.Status.OK : failureStatus;
            return validationResult;
        }
        return failureStatus;
    }

    public boolean isSchemaValid(File setFile) {
        try {
            URL schemaFile = new URL(this.mavenSettingsXSD);
            StreamSource xmlFile = new StreamSource(setFile);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(schemaFile);
            Validator validator = schema.newValidator();
            validator.validate(xmlFile);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean isValidXml(File file) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            String fileType = URLConnection.guessContentTypeFromStream(in);
            if (fileType == null || !fileType.equals("application/xml")) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private boolean determineSettingsVersion(File file) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(file);
            String schemaLocation = dom.getElementsByTagName("settings").item(0).getNamespaceURI();
            this.setMavenSettingsVersion(this.getVersion(schemaLocation));
        }
        catch (IOException | NullPointerException | ParserConfigurationException | SAXException e) {
            return false;
        }
        return true;
    }

    private String getVersion(String schemaLocation) {
        String[] splitLocation = schemaLocation.split("/");
        return Arrays.asList(splitLocation).get(splitLocation.length - 1);
    }

    private void setMavenSettingsVersion(String version) {
        this.mavenSettingsVersion = version;
        this.mavenSettingsXSD = "http://maven.apache.org/xsd/settings-" + this.mavenSettingsVersion + ".xsd";
    }
}

