/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.installation.maven.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.VariableSubstitutor;
import com.redhat.installer.installation.validator.CharacterPathValidator;
import java.io.File;

public class MavenSettingsValidator
implements DataValidator {
    AutomatedInstallData idata;
    String errorMessageId;
    String warningMessageId;
    String formattedMessage;

    @Override
    public DataValidator.Status validateData(AutomatedInstallData adata) {
        this.idata = adata;
        return this.setMavenSettingsPath();
    }

    private DataValidator.Status setMavenSettingsPath() {
        VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
        boolean useDefault = Boolean.parseBoolean(this.idata.getVariable("useDefaultMavenSettingsLocation"));
        if (useDefault) {
            this.idata.setVariable("MAVEN_SETTINGS_FULLPATH", vs.substitute(this.idata.getVariable("MAVEN_SETTINGS_FULLPATH.default")));
            return DataValidator.Status.OK;
        }
        String settingsPath = this.idata.getVariable("MAVEN_SETTINGS_FULLPATH");
        if (settingsPath.isEmpty()) {
            this.setErrorAndMessage("MavenRepoCheckPanel.settings.empty", new String[0]);
            return DataValidator.Status.ERROR;
        }
        File settingsFile = new File(settingsPath);
        if (settingsFile.getPath().toLowerCase().startsWith("http")) {
            this.setErrorAndMessage("MavenRepoCheckPanel.settings.invalid", new String[0]);
            return DataValidator.Status.ERROR;
        }
        String quickstartPath = this.idata.getVariable("install.quickstarts.path");
        if (settingsPath.equals(quickstartPath)) {
            settingsFile = new File(quickstartPath, "settings.xml");
        }
        if (settingsFile.isDirectory()) {
            settingsFile = new File(settingsPath, "settings.xml");
            this.idata.setVariable("MAVEN_SETTINGS_FULLPATH", settingsFile.getAbsolutePath());
        }
        if (!settingsFile.exists()) {
            return this.createExampleSettings(settingsFile);
        }
        if (settingsFile.length() == 0L) {
            this.setWarningAndMessage("MavenRepoCheckPanel.settings.empty.overwrite", settingsFile.getAbsolutePath());
            return DataValidator.Status.WARNING;
        }
        this.setWarningAndMessage("MavenRepoCheckPanel.settings.update.warning", settingsFile.getAbsolutePath());
        return DataValidator.Status.WARNING;
    }

    private DataValidator.Status createExampleSettings(File settingsFile) {
        File existingParent = IoHelper.existingParent(settingsFile);
        if (existingParent == null) {
            this.setErrorAndMessage("MavenRepoCheckPanel.drive.error", settingsFile.getAbsolutePath().substring(0, 2));
            return DataValidator.Status.ERROR;
        }
        if (!existingParent.canWrite() || !existingParent.canExecute()) {
            this.setErrorAndMessage("MavenRepoCheckPanel.dir.error", existingParent.getAbsolutePath());
            return DataValidator.Status.ERROR;
        }
        if (!CharacterPathValidator.validate(new File(existingParent.getPath()))) {
            this.setErrorAndMessage("CharacterPathValidator.invalid", CharacterPathValidator.getInvalidCharacters());
            return DataValidator.Status.ERROR;
        }
        this.setWarningAndMessage("MavenRepoCheckPanel.settings.error", settingsFile.getAbsolutePath());
        this.idata.setVariable("MAVEN_SETTINGS_FULLPATH", settingsFile.getAbsolutePath());
        return DataValidator.Status.WARNING;
    }

    private void setWarningAndMessage(String id, String ... format) {
        this.setWarningMessageId(id);
        this.setFormattedMessage(String.format(this.idata.langpack.getString(this.getWarningMessageId()), format));
    }

    private void setErrorAndMessage(String id, String ... format) {
        this.setErrorMessageId(id);
        this.setFormattedMessage(String.format(this.idata.langpack.getString(this.getErrorMessageId()), format));
    }

    private void setErrorMessageId(String e) {
        this.errorMessageId = e;
    }

    @Override
    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    private void setWarningMessageId(String w) {
        this.warningMessageId = w;
    }

    @Override
    public String getWarningMessageId() {
        return this.warningMessageId;
    }

    @Override
    public boolean getDefaultAnswer() {
        return true;
    }

    private void setFormattedMessage(String m) {
        this.formattedMessage = m;
    }

    @Override
    public String getFormattedMessage() {
        return this.formattedMessage;
    }
}

