/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.installation.processpanel;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class ArgumentParser {
    private static final String ARGS_OPTION = "--";
    private static final String EQUAL_SIGN = "=";
    private static final int ARGS_OPTION_LENGTH = "--".length();
    private final PropertiesConfiguration property = new PropertiesConfiguration();

    public void parse(String[] args) {
        VariableSubstitutor vs = new VariableSubstitutor(AutomatedInstallData.getInstance().getVariables());
        try {
            for (String argument : args) {
                if (!argument.startsWith(ARGS_OPTION) || !argument.contains(EQUAL_SIGN)) continue;
                String subbedArg = vs.substitute(argument.substring(ARGS_OPTION_LENGTH).replaceAll("\\\\", "\\\\\\\\"));
                this.property.load(new StringReader(subbedArg));
            }
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void deepParse(String[] args) {
        VariableSubstitutor vs = new VariableSubstitutor(AutomatedInstallData.getInstance().getVariables());
        try {
            for (String argument : args) {
                if (!argument.startsWith(ARGS_OPTION) || !argument.contains(EQUAL_SIGN)) continue;
                String subbedArg = vs.deepSubstitute(argument.substring(ARGS_OPTION_LENGTH).replaceAll("\\\\", "\\\\\\\\"), "java");
                this.property.load(new StringReader(subbedArg));
            }
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }

    public String getStringProperty(String key) {
        return this.property.getString(key);
    }

    public String getStringProperty(String key, String defaultValue) {
        return this.property.getString(key, defaultValue);
    }

    public boolean hasProperty(String key) {
        return this.property.containsKey(key);
    }

    public List<String> getListProperty(String key) {
        ArrayList<String> retval = new ArrayList<String>();
        List<Object> os = this.property.getList(key);
        for (Object o : os) {
            retval.add((String)o);
        }
        return retval;
    }

    public List<String> getListProperty(String key, List<String> defaultValue) {
        if (this.getListProperty(key).isEmpty()) {
            return defaultValue;
        }
        return this.getListProperty(key);
    }

    public boolean propertyIsTrue(String key) {
        return this.hasProperty(key) && this.getStringProperty(key).equalsIgnoreCase("true");
    }

    public void setListDelimiter(char delim) {
        this.property.setListDelimiter(delim);
    }
}

