/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.installation.processpanel;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.installation.processpanel.ArgumentParser;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class CommandRunner {
    private static AbstractUIProcessHandler mHandler;
    private static BufferedReader in;
    private static BufferedWriter out;

    public static boolean run(AbstractUIProcessHandler handler, String[] args) {
        mHandler = handler;
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String workingDirectory = idata.getInstallPath() + File.separator;
        ArgumentParser parser = new ArgumentParser();
        parser.parse(args);
        boolean mute = args[0].equals("--mute=true");
        String[] arguments = mute ? new String[args.length - 1] : new String[args.length];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = mute ? args[i + 1] : args[i];
        }
        ProcessBuilder builder = new ProcessBuilder(arguments);
        builder.directory(new File(workingDirectory));
        ProcessPanelHelper.adjustJbossHome(builder);
        try {
            if (!mute) {
                ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("CommandRunner.running") + builder.command(), false);
            }
            builder.redirectErrorStream(true);
            Process p = builder.start();
            in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            out = new BufferedWriter(new OutputStreamWriter(p.getOutputStream()));
            out.newLine();
            out.flush();
            Thread eater = new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedWriter log = null;
                    try {
                        String line;
                        log = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(AutomatedInstallData.getInstance().getInstallPath() + "/" + AutomatedInstallData.getInstance().getVariable("installation.logfile"), true)));
                        while ((line = in.readLine()) != null) {
                            ProcessPanelHelper.printToPanel(mHandler, line, false);
                        }
                        log.close();
                    }
                    catch (IOException e) {
                    }
                    finally {
                        if (log != null) {
                            try {
                                log.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            });
            eater.start();
            int exit = p.waitFor();
            in.close();
            out.close();
            if (exit != 0) {
                if (!mute) {
                    ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("CommandRunner.failure") + " " + builder.command() + " " + idata.langpack.getString("CommandRunner.failure2") + " " + p.exitValue(), true);
                } else {
                    ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("CommandRunner.mute.failure") + " " + p.exitValue(), true);
                }
                return false;
            }
            if (!mute) {
                ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("CommandRunner.success") + " " + builder.command() + " " + idata.langpack.getString("CommandRunner.success2"), false);
            }
        }
        catch (InterruptedException e) {
            ProcessPanelHelper.printToLog(e.toString());
            String errorMessage = idata.langpack.getString("CommandRunner.IOfailure");
            ProcessPanelHelper.printToPanel(mHandler, String.format(errorMessage, args[0]), true);
            return false;
        }
        catch (IOException e) {
            ProcessPanelHelper.printToLog(e.toString());
            String errorMessage = idata.langpack.getString("CommandRunner.IOfailure");
            ProcessPanelHelper.printToPanel(mHandler, String.format(errorMessage, args[0]), true);
            return false;
        }
        return true;
    }
}

