/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.installation.processpanel;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import com.redhat.installer.installation.util.InstallationUtilities;
import java.io.File;
import java.io.IOException;

public class EmptyFileCreator {
    public static boolean run(AbstractUIProcessHandler handler, String[] args) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        for (String file : args) {
            File emptyFile = new File(file);
            if (!emptyFile.exists()) {
                try {
                    if (!emptyFile.createNewFile()) {
                        ProcessPanelHelper.printToPanel(handler, String.format(idata.langpack.getString("directory.creation.failed"), emptyFile.toString()), true);
                        return false;
                    }
                    ProcessPanelHelper.printToPanel(handler, String.format(idata.langpack.getString("EmptyFileCreator.creation"), emptyFile.getAbsolutePath()), false);
                    InstallationUtilities.addFileToCleanupList(file);
                    continue;
                }
                catch (IOException ioe) {
                    ProcessPanelHelper.printToPanel(handler, String.format(idata.langpack.getString("EmptyFileCreator.creationfailed"), emptyFile.getAbsolutePath()), true);
                    ProcessPanelHelper.printStackTraceToPanel(handler, ioe);
                    return false;
                }
            }
            ProcessPanelHelper.printToPanel(handler, String.format(idata.langpack.getString("EmptyFileCreator.existing"), emptyFile.getAbsolutePath()), false);
        }
        return true;
    }
}

