/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.installation.processpanel;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.izforge.izpack.util.VariableSubstitutor;
import com.redhat.installer.installation.processpanel.ArgumentParser;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class FileDeleter {
    public static final String MSG_ENABLED = "enable-messages";

    private static void deleteFile(File toDelete, boolean displayMessages, AbstractUIProcessHandler handler, AutomatedInstallData idata) {
        try {
            FileUtils.forceDelete(toDelete);
            if (displayMessages) {
                ProcessPanelHelper.printToPanel(handler, idata.langpack.getString("FileDeleter.success") + " " + toDelete.getAbsolutePath(), false);
            }
        }
        catch (IOException e) {
            if (displayMessages) {
                ProcessPanelHelper.printToPanel(handler, idata.langpack.getString("FileDeleter.failure") + " " + toDelete.getAbsolutePath(), true);
            }
            ProcessPanelHelper.printToLog(e.toString());
        }
    }

    private static void deleteTmpFiles(boolean displayMessages, AbstractUIProcessHandler handler, AutomatedInstallData idata) {
        for (String file : idata.tmpFiles) {
            File toDelete = new File(file);
            if (!toDelete.exists()) continue;
            FileDeleter.deleteFile(toDelete, displayMessages, handler, idata);
        }
    }

    public static void run(AbstractUIProcessHandler handler, String[] args) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
        ArgumentParser parser = new ArgumentParser();
        parser.parse(args);
        boolean displayMessages = parser.hasProperty(MSG_ENABLED);
        for (String arg : args) {
            if (arg == null) continue;
            if (arg.equals("deleteTmp")) {
                FileDeleter.deleteTmpFiles(displayMessages, handler, idata);
                continue;
            }
            File toDelete = new File(vs.substitute(arg));
            if (!toDelete.exists()) continue;
            FileDeleter.deleteFile(toDelete, displayMessages, handler, idata);
        }
    }
}

