/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.installation.processpanel;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.installation.processpanel.ArgumentParser;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class FileMover {
    private static final String COPY = "copy";
    private static final String MSG_ENABLED = "enable-messages";
    private static final String SOURCE = "source";
    private static final String DEST = "destination";
    private static final String DEST_IS_FILE = "dest-is-file";
    private static Operation operation;

    public static void run(AbstractUIProcessHandler handler, String[] args) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        ArgumentParser parser = new ArgumentParser();
        parser.parse(args);
        FileMover.decideOperation(parser);
        boolean displayMessages = parser.hasProperty(MSG_ENABLED) && Boolean.parseBoolean(parser.getStringProperty(COPY));
        List<String> sources = parser.getListProperty(SOURCE);
        if ((operation == Operation.COPY_FILE || operation == Operation.MOVE_FILE) && sources.size() > 1) {
            ProcessPanelHelper.printToPanel(handler, idata.langpack.getString("FileMover.missing.args"), true);
            return;
        }
        if (parser.hasProperty(SOURCE) && parser.hasProperty(DEST)) {
            File dest = new File(parser.getStringProperty(DEST));
            if (!dest.isDirectory() && dest.exists()) {
                ProcessPanelHelper.printToPanel(handler, idata.langpack.getString("FileMover.dest.exists"), true);
                return;
            }
            for (String s : sources) {
                File source = new File(s);
                String sourcePath = source.getAbsolutePath();
                if (!source.exists()) {
                    ProcessPanelHelper.printToPanel(handler, String.format(idata.langpack.getString("FileMover.source.notexist"), sourcePath), false);
                    continue;
                }
                try {
                    FileMover.performOperation(source, dest);
                }
                catch (IOException e) {
                    ProcessPanelHelper.printToPanel(handler, String.format(idata.langpack.getString("FileMover.copy.failed"), sourcePath, dest.getAbsolutePath()), true);
                    continue;
                }
                if (!displayMessages) continue;
                ProcessPanelHelper.printToPanel(handler, String.format(idata.langpack.getString("FileMover.copy.success"), sourcePath, dest.getAbsolutePath()), false);
            }
        } else {
            ProcessPanelHelper.printToPanel(handler, idata.langpack.getString("FileMover.missing.args"), true);
            return;
        }
    }

    private static void decideOperation(ArgumentParser parser) {
        boolean destIsFile = parser.hasProperty(DEST_IS_FILE);
        boolean copyFile = parser.hasProperty(COPY);
        File sourceFile = new File(parser.getStringProperty(SOURCE));
        boolean sourceIsDirectory = sourceFile.isDirectory();
        operation = copyFile ? (sourceIsDirectory ? (destIsFile ? Operation.COPY_DIR : Operation.COPY_DIR_TO_DIRECTORY) : (destIsFile ? Operation.COPY_FILE : Operation.COPY_FILE_TO_DIRECTORY)) : (sourceIsDirectory ? (destIsFile ? Operation.MOVE_DIR : Operation.MOVE_DIR_TO_DIRECTORY) : (destIsFile ? Operation.MOVE_FILE : Operation.MOVE_FILE_TO_DIRECTORY));
    }

    private static void performOperation(File source, File dest) throws IOException {
        switch (operation) {
            case COPY_FILE: {
                FileUtils.copyFile(source, dest);
                break;
            }
            case COPY_FILE_TO_DIRECTORY: {
                FileUtils.copyFileToDirectory(source, dest, true);
                break;
            }
            case COPY_DIR: {
                FileUtils.copyDirectory(source, dest);
                break;
            }
            case COPY_DIR_TO_DIRECTORY: {
                FileUtils.copyDirectoryToDirectory(source, dest);
                break;
            }
            case MOVE_FILE: {
                FileUtils.moveFile(source, dest);
                break;
            }
            case MOVE_FILE_TO_DIRECTORY: {
                FileUtils.moveFileToDirectory(source, dest, true);
                break;
            }
            case MOVE_DIR: {
                FileUtils.moveDirectory(source, dest);
                break;
            }
            case MOVE_DIR_TO_DIRECTORY: {
                FileUtils.moveDirectoryToDirectory(source, dest, true);
            }
        }
    }

    private static enum Operation {
        COPY_FILE,
        COPY_FILE_TO_DIRECTORY,
        MOVE_FILE,
        MOVE_FILE_TO_DIRECTORY,
        COPY_DIR,
        COPY_DIR_TO_DIRECTORY,
        MOVE_DIR,
        MOVE_DIR_TO_DIRECTORY;

    }
}

