/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.installation.processpanel;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.izforge.izpack.util.OsVersion;
import com.redhat.installer.installation.processpanel.ArgumentParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;

public class ProcessPanelHelper {
    private static final String UNZIP_NATIVES = "unzip-natives";
    private static AbstractUIProcessHandler mHandler;

    public static void run(AbstractUIProcessHandler handler, String[] args) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        mHandler = handler;
        ArgumentParser parser = new ArgumentParser();
        parser.parse(args);
        if (parser.hasProperty(UNZIP_NATIVES)) {
            File[] list;
            boolean hasCp;
            boolean hasLink;
            boolean hasUnzip;
            String installPath = idata.getInstallPath();
            File installPathFile = new File(installPath);
            String nativesUnzipPath = installPath + "/" + idata.getVariable("eap.native.parent.path");
            File nativesUnzipFile = new File(nativesUnzipPath);
            try {
                Runtime.getRuntime().exec("unzip");
                hasUnzip = true;
            }
            catch (Exception e) {
                hasUnzip = false;
            }
            try {
                Runtime.getRuntime().exec("ln");
                hasLink = true;
            }
            catch (Exception e) {
                hasLink = false;
            }
            try {
                Runtime.getRuntime().exec("cp");
                hasCp = true;
            }
            catch (Exception e) {
                hasCp = false;
            }
            FilenameFilter zipFilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".zip");
                }
            };
            ArrayList<String> sha256sums = new ArrayList<String>();
            for (File sourceZipPath : list = new File(installPath).listFiles(zipFilter)) {
                if (hasUnzip && !OsVersion.IS_SUNOS && !OsVersion.IS_WINDOWS) {
                    try {
                        Process p = new ProcessBuilder("unzip", "-o", sourceZipPath.toString(), "-d", installPath).start();
                        if (p.waitFor() != 0) {
                            throw new RuntimeException("Native unzip utility exited abnormally for " + sourceZipPath);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Couldn't exec native unzip utility", e);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    if (!sourceZipPath.delete()) {
                        System.err.println("Couldn't delete temporary zip " + sourceZipPath);
                    }
                    sha256sums.addAll(ProcessPanelHelper.getSHA256sums());
                    continue;
                }
                ZipFile zipFile = null;
                try {
                    zipFile = new ZipFile(sourceZipPath);
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        boolean validPath;
                        String secondLine;
                        String firstLine;
                        ZipEntry entry = entries.nextElement();
                        File destinationPath = new File(installPath, entry.getName());
                        destinationPath.getParentFile().mkdirs();
                        if (entry.isDirectory()) {
                            if (destinationPath.mkdir()) continue;
                            ProcessPanelHelper.printToPanel(mHandler, String.format(idata.langpack.getString("directory.creation.failed"), destinationPath.toString()), true);
                            return;
                        }
                        FileOutputStream fos = null;
                        FileChannel outputChannel = null;
                        try {
                            fos = new FileOutputStream(destinationPath);
                            outputChannel = fos.getChannel();
                            ReadableByteChannel inputChannel = Channels.newChannel(zipFile.getInputStream(entry));
                            outputChannel.transferFrom(inputChannel, 0L, Long.MAX_VALUE);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Can't write destination file " + destinationPath, e);
                        }
                        finally {
                            if (fos != null) {
                                try {
                                    fos.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (outputChannel != null) {
                                try {
                                    outputChannel.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        if (!hasLink || entry.getMethod() != 0) continue;
                        BufferedReader reader = null;
                        try {
                            reader = new BufferedReader(new FileReader(destinationPath));
                            firstLine = reader.readLine();
                            secondLine = reader.readLine();
                        }
                        catch (FileNotFoundException e) {
                            throw new RuntimeException("File written from zip does not exist " + destinationPath, e);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("File written from zip cannot be read " + destinationPath, e);
                        }
                        finally {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        if (secondLine != null) continue;
                        File symlinkTarget = new File(firstLine);
                        try {
                            symlinkTarget.getCanonicalPath();
                            validPath = true;
                        }
                        catch (IOException e) {
                            validPath = false;
                        }
                        if (!validPath) continue;
                        try {
                            Process p = new ProcessBuilder("ln", "-s", "-f", symlinkTarget.toString(), destinationPath.toString()).start();
                            if (p.waitFor() == 0) continue;
                            throw new RuntimeException("Link utility exited abnormally when converting " + destinationPath);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Couldn't exec link utility", e);
                        }
                        catch (InterruptedException e) {
                            try {
                                if (zipFile != null) {
                                    zipFile.close();
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            sourceZipPath.delete();
                            return;
                        }
                    }
                    sha256sums.addAll(ProcessPanelHelper.getSHA256sums());
                }
                catch (IOException e) {
                    throw new RuntimeException("Can't extract zip file " + sourceZipPath, e);
                }
                finally {
                    try {
                        if (zipFile != null) {
                            zipFile.close();
                        }
                    }
                    catch (IOException iOException) {}
                    sourceZipPath.delete();
                }
            }
            if (!sha256sums.isEmpty()) {
                ProcessPanelHelper.writeSHA256sums(sha256sums);
            }
            try {
                File[] nativeFiles = nativesUnzipFile.listFiles();
                if (nativeFiles != null) {
                    for (File f : nativeFiles) {
                        Process cp;
                        if (f.isDirectory()) {
                            if (!OsVersion.IS_WINDOWS && hasCp) {
                                cp = new ProcessBuilder("cp", "-rP", f.getCanonicalPath(), installPathFile.getCanonicalPath()).start();
                                cp.waitFor();
                                ProcessPanelHelper.printToPanel(handler, idata.langpack.getString("CommandRunner.success") + " cp -rP " + f.getCanonicalPath() + " " + installPathFile.getCanonicalPath(), false);
                                continue;
                            }
                            FileUtils.copyDirectoryToDirectory(f, installPathFile);
                            continue;
                        }
                        if (!OsVersion.IS_WINDOWS && hasCp) {
                            cp = new ProcessBuilder("cp", f.getCanonicalPath(), installPathFile.getCanonicalPath()).start();
                            cp.waitFor();
                            ProcessPanelHelper.printToPanel(handler, idata.langpack.getString("CommandRunner.success") + " cp " + f.getCanonicalPath() + " " + installPathFile.getCanonicalPath(), false);
                            continue;
                        }
                        FileUtils.copyFileToDirectory(f, installPathFile, false);
                    }
                    FileUtils.deleteDirectory(nativesUnzipFile);
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("Can't move natives from: " + nativesUnzipFile.getAbsolutePath() + " to appropriate location " + installPathFile.getAbsolutePath(), ioe);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Copy process failed:", e);
            }
            handler.logOutput(idata.langpack.getString("postinstall.processpanel.unpacking.complete"), false);
        }
    }

    private static void writeSHA256sums(List<String> sums) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        File sumFile = new File(idata.getInstallPath() + "/" + idata.getVariable("eap.native.parent.path") + "/SHA256SUM");
        if (!sumFile.delete()) {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("FileDeleter.failure") + " " + sumFile.toString(), true);
        }
        BufferedWriter br = null;
        try {
            br = new BufferedWriter(new FileWriter(sumFile));
            for (String sum : sums) {
                br.write(sum + "\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write master zip SHA256SUM file to " + sumFile, e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getSHA256sums() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        File sumFile = new File(idata.getInstallPath() + "/" + idata.getVariable("eap.native.parent.path") + "/SHA256SUM");
        ArrayList<String> retval = new ArrayList<String>();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(sumFile));
            while ((line = br.readLine()) != null) {
                retval.add(line);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return retval;
    }

    public static void adjustJbossHome(ProcessBuilder builder) {
        Map<String, String> env = builder.environment();
        String installPath = AutomatedInstallData.getInstance().getInstallPath();
        if (installPath.endsWith(File.separator)) {
            installPath = installPath.substring(0, installPath.length() - 1);
        }
        env.put("JBOSS_HOME", installPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printToPanel(AbstractUIProcessHandler handler, String message, boolean error) {
        BufferedWriter log = ProcessPanelHelper.getLogWriter();
        String ignoreMsg = "Press any key to continue";
        try {
            if (!message.contains(ignoreMsg)) {
                handler.logOutput(message, error);
            }
            log.write(message);
            log.newLine();
            log.flush();
        }
        catch (IOException e) {
            ProcessPanelHelper.printToLog(e);
        }
        finally {
            try {
                log.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void printStackTraceToPanel(AbstractUIProcessHandler handler, Throwable e) {
        String message = "\t at %s";
        try (BufferedWriter log = ProcessPanelHelper.getLogWriter();){
            handler.logOutput(e.toString(), true);
            log.write(e.toString() + "\n");
            log.flush();
            for (StackTraceElement stackTraceElement : e.getStackTrace()) {
                handler.logOutput(String.format(message, stackTraceElement.toString()), true);
                log.write(String.format(message, stackTraceElement.toString()) + "\n");
                log.flush();
            }
            for (Serializable serializable : e.getSuppressed()) {
                ProcessPanelHelper.printStackTraceToPanel(handler, (Throwable)serializable);
            }
            Throwable cause = e.getCause();
            if (cause != null) {
                ProcessPanelHelper.printStackTraceToPanel(handler, cause);
            }
        }
        catch (IOException ioe) {
            ProcessPanelHelper.printToLog(ioe);
        }
    }

    public static void printToLog(Object message) {
        BufferedWriter log = ProcessPanelHelper.getLogWriter();
        try {
            log.write(message.toString());
            log.newLine();
            log.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                log.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static BufferedWriter getLogWriter() {
        BufferedWriter log = null;
        try {
            AutomatedInstallData idata = AutomatedInstallData.getInstance();
            log = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(idata.getInstallPath() + File.separator + idata.getVariable("installation.logfile"), true)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printExceptionToLog(StackTraceElement[] e) {
        BufferedWriter log = ProcessPanelHelper.getLogWriter();
        try {
            for (StackTraceElement ste : e) {
                log.write(ste.toString());
                log.newLine();
            }
            log.flush();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        finally {
            try {
                log.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }
}

