/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.installation.processpanel;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.installation.processpanel.ArgumentParser;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class TextFileAppender {
    private static final String FILE = "file";
    private static final String TEXT = "text";
    private static final String IF = "||IF||";
    private static final String NOT = "||NOT||";
    private static AutomatedInstallData idata;
    private static AbstractUIProcessHandler mHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean run(AbstractUIProcessHandler handler, String[] args) {
        idata = AutomatedInstallData.getInstance();
        mHandler = handler;
        ArgumentParser parser = new ArgumentParser();
        parser.parse(args);
        List<String> filePaths = parser.getListProperty(FILE);
        for (String appendTargerPath : filePaths) {
            File appendTarget = new File(appendTargerPath);
            appendTarget.getParentFile().mkdirs();
            PrintWriter pw = null;
            try {
                pw = new PrintWriter(new FileWriter(appendTarget, true));
                if (parser.hasProperty(TEXT)) {
                    pw.println();
                    pw.println(parser.getStringProperty(TEXT));
                    continue;
                }
                for (int i = 1; i < args.length; ++i) {
                    String line = TextFileAppender.checkCondition(args[i]);
                    if (line == null) continue;
                    pw.println(line);
                }
            }
            catch (IOException e) {
                ProcessPanelHelper.printToPanel(mHandler, TextFileAppender.idata.langpack.getString("TextFileAppender.append.failed"), true);
                ProcessPanelHelper.printStackTraceToPanel(mHandler, e);
                boolean bl = false;
                return bl;
            }
            finally {
                if (pw == null) continue;
                pw.close();
            }
        }
        return true;
    }

    private static String checkCondition(String line) {
        String[] words = line.split(" ");
        if (words[0].equals(IF)) {
            if (words[1].equals("true")) {
                Object[] actualLine = Arrays.copyOfRange(words, 2, words.length);
                return StringUtils.join(actualLine, " ");
            }
            return null;
        }
        if (words[0].equals(NOT)) {
            if (words[1].equals("false")) {
                Object[] actualLine = Arrays.copyOfRange(words, 2, words.length);
                return StringUtils.join(actualLine, " ");
            }
            return null;
        }
        return line;
    }
}

