/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.installation.processpanel;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.installation.processpanel.ArgumentParser;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class TextReplacer {
    private static final String FILE = "file";
    private static final String REGEX = "regex";
    private static final String TEXT = "text";
    private static final String REPLACE = "replace";
    private static final String SELF = "\\|\\|SELF\\|\\|";
    private static final String REMOVE = "remove";
    private static final String OPTIONAL = "optional";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean run(AbstractUIProcessHandler handler, String[] args) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        ArgumentParser parser = new ArgumentParser();
        parser.parse(args);
        if (!parser.hasProperty(TEXT) || parser.hasProperty(REGEX) && parser.hasProperty(REPLACE)) {
            ProcessPanelHelper.printToPanel(handler, "ProcessPanel.spec.xml has incorrect parameters", true);
            return false;
        }
        String newString = parser.getStringProperty(TEXT);
        List<String> filePaths = parser.getListProperty(FILE);
        List<String> OptionalFiles = parser.getListProperty(OPTIONAL);
        TextReplacer.outputMessage(handler, parser, idata, filePaths, newString);
        for (String filePath : filePaths) {
            ArrayList<String> lines = new ArrayList<String>();
            File file = new File(filePath);
            int linesChanged = 0;
            FileInputStream fis = null;
            BufferedReader reader = null;
            BufferedWriter writer = null;
            try {
                String line;
                fis = new FileInputStream(file);
                reader = new BufferedReader(new InputStreamReader((InputStream)fis, Charset.forName("UTF-8")));
                if (parser.hasProperty(REGEX)) {
                    String regex = parser.getStringProperty(REGEX);
                    while ((line = reader.readLine()) != null) {
                        if (line.matches(regex)) {
                            if (parser.hasProperty(REMOVE)) {
                                String removeString = parser.getStringProperty(REMOVE);
                                lines.add(line.replaceAll(removeString, ""));
                            } else {
                                String escapedLine = line.replaceAll("\\$", "\\\\\\$");
                                newString = newString.replaceAll(SELF, escapedLine);
                                newString = newString.replaceAll("\\$", "\\\\\\$");
                                line = line.replaceAll(regex, newString);
                                lines.add(line);
                            }
                            ++linesChanged;
                            continue;
                        }
                        lines.add(line);
                    }
                } else if (parser.hasProperty(REPLACE)) {
                    String replaceString = parser.getStringProperty(REPLACE);
                    while ((line = reader.readLine()) != null) {
                        if (line.contains(replaceString)) {
                            lines.add(line.replace(replaceString, newString));
                            ++linesChanged;
                            continue;
                        }
                        lines.add(line);
                    }
                }
                fis.close();
                reader.close();
                FileWriter fw = new FileWriter(file);
                writer = new BufferedWriter(fw);
                for (String s : lines) {
                    writer.write(s);
                    writer.newLine();
                }
                writer.flush();
                writer.close();
            }
            catch (Exception e) {
                if (OptionalFiles.contains(filePath)) {
                    ProcessPanelHelper.printToPanel(handler, String.format(idata.langpack.getString("TextReplacer.optional.skipped"), file.getAbsolutePath()), false);
                    boolean bl = true;
                    return bl;
                }
                ProcessPanelHelper.printToPanel(handler, String.format(idata.langpack.getString("TextReplacer.error"), file.getAbsolutePath()), true);
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (writer == null) continue;
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    private static void outputMessage(AbstractUIProcessHandler handler, ArgumentParser parser, AutomatedInstallData idata, List<String> filePaths, String newString) {
        if (parser.hasProperty(REGEX)) {
            String regex = parser.getStringProperty(REGEX);
            if (parser.hasProperty(REMOVE)) {
                String removeString = parser.getStringProperty(REMOVE);
                ProcessPanelHelper.printToPanel(handler, String.format(idata.langpack.getString("TextReplacer.removal"), removeString), false);
            } else {
                ProcessPanelHelper.printToPanel(handler, String.format(idata.langpack.getString("TextReplacer.replaceline"), regex, newString), false);
            }
        } else if (parser.hasProperty(REPLACE)) {
            String replaceString = parser.getStringProperty(REPLACE);
            ProcessPanelHelper.printToPanel(handler, String.format(idata.langpack.getString("TextReplacer.replacetext"), replaceString, newString), false);
        }
        TextReplacer.printFilePaths(handler, filePaths);
    }

    private static void printFilePaths(AbstractUIProcessHandler handler, List<String> filePaths) {
        for (String file : filePaths) {
            ProcessPanelHelper.printToPanel(handler, file.toString(), false);
        }
    }
}

