/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.installation.util;

import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.util.Debug;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;

public class InstallationUtilities {
    private static final String SEP = File.separator;
    private static final String pathToMgmtFile = SEP + "configuration" + SEP + "mgmt-users.properties";
    private static final String[] profiles = new String[]{"standalone", "domain"};

    public static void removeManagementUser(String username, String path) {
        try {
            StringBuilder file = new StringBuilder();
            for (String profile : profiles) {
                String line;
                FileReader reader = new FileReader(path + SEP + profile + pathToMgmtFile);
                BufferedReader in = new BufferedReader(reader);
                boolean foundUsername = false;
                file.setLength(0);
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    if (line.contains(username)) {
                        foundUsername = true;
                        continue;
                    }
                    file.append(line);
                    file.append(System.getProperty("line.separator"));
                }
                in.close();
                reader.close();
                if (!foundUsername) continue;
                FileWriter writer = new FileWriter(path + "/" + profile + pathToMgmtFile, false);
                writer.write(file.toString());
                writer.close();
            }
        }
        catch (Exception e) {
            Debug.log("Error replacing mgmt-users.properties file: " + e.getMessage());
        }
    }

    public static void addFileToCleanupList(String path) {
        UninstallData udata = UninstallData.getInstance();
        udata.getInstalledFilesList().add(path);
    }
}

