/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.installation.validator;

import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import java.util.Map;

public class BlackListValidator
implements Validator {
    private static final String LIST_PARAM = "blacklist";

    @Override
    public Validator.Status validate(ProcessingClient client) {
        String blackListString;
        Validator.Status failureStatus = Validator.Status.ERROR;
        if (client.hasParams() && Boolean.parseBoolean(client.getValidatorParams().get("warning"))) {
            failureStatus = Validator.Status.WARNING;
        }
        if (client.hasParams()) {
            Map<String, String> paramMap = client.getValidatorParams();
            blackListString = paramMap.get(LIST_PARAM);
        } else {
            blackListString = "";
        }
        String[] blackList = blackListString.split(",");
        String userString = this.getString(client);
        for (String word : blackList) {
            if (!word.equals(userString)) continue;
            return failureStatus;
        }
        return Validator.Status.OK;
    }

    private String getString(ProcessingClient client) {
        String returnValue = client.getText();
        return returnValue;
    }
}

