/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.installation.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import java.io.File;
import java.util.ArrayList;

public class CharacterPathValidator
implements Validator,
DataValidator {
    AutomatedInstallData idata;
    String error;
    String message;
    public static final String[] invalidCharacters = new String[]{"  ", "?", "%", ":"};
    public static final String[] invalidWindows = new String[]{"<", ">", ":", "\"", "/", "\\\\", "|", "?", "*", "\\ "};
    public static final String[] invalidUnix = new String[]{"\\0", "//", ";", "\\", "\""};

    public static boolean validate(File dir) {
        return CharacterPathValidator.checkDirectory(dir.getAbsolutePath());
    }

    @Override
    public Validator.Status validate(ProcessingClient client) {
        this.idata = AutomatedInstallData.getInstance();
        int numFields = client.getNumFields();
        for (int i = 0; i < numFields; ++i) {
            if (CharacterPathValidator.checkDirectory(client.getFieldContents(i))) continue;
            return Validator.Status.ERROR;
        }
        return Validator.Status.OK;
    }

    @Override
    public DataValidator.Status validateData(AutomatedInstallData idata) {
        String path = idata.getVariable("INSTALL_PATH");
        String invalidChars = CharacterPathValidator.getInvalidCharacters();
        if (!CharacterPathValidator.checkDirectory(path)) {
            this.setError(String.format(idata.langpack.getString("TargetPanel.invalid"), invalidChars));
            this.message = idata.langpack.getString(this.error);
            return DataValidator.Status.ERROR;
        }
        return DataValidator.Status.OK;
    }

    private static boolean checkDirectory(String path) {
        String filteredPath = path;
        if (System.getProperty("os.name").toLowerCase().contains("window")) {
            if (path.length() <= 2) {
                return false;
            }
            filteredPath = path.substring(2, path.length());
            if (!CharacterPathValidator.isValidString(filteredPath, invalidWindows)) {
                return false;
            }
        } else if (!CharacterPathValidator.isValidString(filteredPath, invalidUnix)) {
            return false;
        }
        for (String character : invalidCharacters) {
            if (!filteredPath.contains(character)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidString(String input, String[] filter) {
        for (String character : filter) {
            if (!input.contains(character)) continue;
            return false;
        }
        return true;
    }

    public static String getInvalidCharacters() {
        String invalidChars = "";
        ArrayList<String> invalidList = new ArrayList<String>();
        for (String installerChar : invalidCharacters) {
            invalidList.add(installerChar);
        }
        if (System.getProperty("os.name").toLowerCase().contains("window")) {
            for (String winChar : invalidWindows) {
                if (invalidList.contains(winChar)) continue;
                invalidList.add(winChar);
            }
        } else {
            for (String unixChar : invalidUnix) {
                if (invalidList.contains(unixChar)) continue;
                invalidList.add(unixChar);
            }
        }
        for (String invalidChar : invalidList) {
            invalidChars = invalidChars + ", \"" + invalidChar + "\"";
        }
        return invalidChars.substring(1);
    }

    public void setError(String e) {
        this.error = e;
    }

    @Override
    public String getErrorMessageId() {
        return this.error;
    }

    @Override
    public String getWarningMessageId() {
        return this.error;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getFormattedMessage() {
        return this.message;
    }
}

