/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.installation.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.util.Debug;
import java.util.Map;

public class CompareIdataVariablesValidator
implements Validator {
    private String VALUE_KEY = "value";
    private String OPERATION_KEY = "operation";

    @Override
    public Validator.Status validate(ProcessingClient client) {
        Validator.Status failureStatus = Validator.Status.ERROR;
        if (client.hasParams() && Boolean.parseBoolean(client.getValidatorParams().get("warning"))) {
            failureStatus = Validator.Status.WARNING;
        }
        boolean result = false;
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        if (client.hasParams()) {
            String fieldValue = client.getFieldContents(0);
            Map<String, String> paramMap = client.getValidatorParams();
            String operation = paramMap.get(this.OPERATION_KEY);
            String value = idata.getVariable(paramMap.get(this.VALUE_KEY));
            if (value == null || operation == null) {
                if (value == null) {
                    Debug.log("Parameter value for CompareIdataVariablesValidator is null");
                }
                if (operation == null) {
                    Debug.log("Parameter operation for CompareIdataVariablesValidator is null");
                }
                return Validator.Status.OK;
            }
            switch (operation.charAt(0)) {
                case '=': {
                    result = fieldValue.equals(value);
                    break;
                }
                case '!': {
                    result = !fieldValue.equals(value);
                }
            }
        } else {
            return failureStatus;
        }
        Validator.Status validationResult = result ? Validator.Status.OK : failureStatus;
        return validationResult;
    }
}

