/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.installation.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;

public class KeytoolExistsValidator
implements DataValidator {
    private String warningId = "KeytoolExistsValidator.noKeytoolFound.warning";
    private String message;
    private String warning;
    private AutomatedInstallData idata;

    @Override
    public DataValidator.Status validateData(AutomatedInstallData idata) {
        this.idata = idata;
        if (this.keytoolExists()) {
            return DataValidator.Status.OK;
        }
        this.warning = this.message = idata.langpack.getString(this.warningId);
        return DataValidator.Status.WARNING;
    }

    private boolean keytoolExists() {
        String[] args = new String[]{"keytool"};
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(args);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            int returnVal = process.waitFor();
            return returnVal == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getErrorMessageId() {
        return this.warning;
    }

    @Override
    public String getWarningMessageId() {
        return this.warning;
    }

    @Override
    public boolean getDefaultAnswer() {
        return true;
    }

    @Override
    public String getFormattedMessage() {
        return this.message;
    }
}

