/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.installation.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class NoPortClashValidator
implements DataValidator {
    private String message;
    private String error;
    private String warning;

    @Override
    public DataValidator.Status validateData(AutomatedInstallData idata) {
        if (!this.available(9990)) {
            this.warning = "NoPortClashValidator.warning";
            this.setMessage(idata.langpack.getString(this.warning));
            return DataValidator.Status.WARNING;
        }
        return DataValidator.Status.OK;
    }

    private void setError(String string) {
        this.error = string;
    }

    private void setMessage(String string) {
        this.message = string;
    }

    @Override
    public String getErrorMessageId() {
        return this.error;
    }

    @Override
    public String getWarningMessageId() {
        return this.warning;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getFormattedMessage() {
        return this.message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean available(int port) {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Invalid start port: " + port);
        }
        ServerSocket ss = null;
        DatagramSocket ds = null;
        Socket s = null;
        try {
            s = new Socket("localhost", port);
            return false;
        }
        catch (IOException iOException) {
            try {
                ss = new ServerSocket(port, 50, InetAddress.getByName("127.0.0.1"));
                ss.setReuseAddress(true);
                ds = new DatagramSocket(port);
                ds.setReuseAddress(true);
                boolean bl = true;
                return bl;
            }
            catch (IOException iOException2) {
            }
            finally {
                if (ds != null) {
                    ds.close();
                }
                if (ss != null) {
                    try {
                        ss.close();
                    }
                    catch (IOException iOException3) {}
                }
            }
            return false;
        }
    }
}

