/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.installation.validator;

import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.installer.ParameteredDataValidator;
import com.izforge.izpack.util.ErrorIzpackPathException;
import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.WarningIzpackPathException;
import java.util.ArrayList;
import java.util.List;

public class PathLengthValidator
extends ParameteredDataValidator {
    private String message;

    public DataValidator.Status checkPathLength(String path, List<Pack> packs) {
        int longest = 0;
        for (Pack pi : packs) {
            longest = longest < pi.longestPath ? pi.longestPath : longest;
        }
        try {
            if (!FileUtil.isPathValidOffset(path, longest)) {
                return DataValidator.Status.ERROR;
            }
        }
        catch (WarningIzpackPathException wipe) {
            this.message = wipe.getMessage();
            return DataValidator.Status.WARNING;
        }
        catch (ErrorIzpackPathException eipe) {
            this.message = eipe.getMessage();
            return DataValidator.Status.ERROR;
        }
        return DataValidator.Status.OK;
    }

    @Override
    public DataValidator.Status validateData(AutomatedInstallData adata) {
        if (this.getParameters().isEmpty()) {
            return DataValidator.Status.ERROR;
        }
        String packString = this.getParameters().get("packs");
        String variableString = this.getParameters().get("variable");
        ArrayList<Pack> packList = new ArrayList<Pack>();
        for (String packId : packString.split(",")) {
            Pack toAdd = adata.getPackage(packId);
            if (toAdd == null) {
                this.message = "Invalid configuration in IzPack xmls.";
                return DataValidator.Status.ERROR;
            }
            packList.add(adata.getPackage(packId));
        }
        return this.checkPathLength(adata.getVariable(variableString), packList);
    }

    @Override
    public String getErrorMessageId() {
        return null;
    }

    @Override
    public String getWarningMessageId() {
        return null;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getFormattedMessage() {
        return this.message;
    }
}

