/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.layering.action;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelActionConfiguration;
import com.izforge.izpack.installer.PanelActionDialog;
import com.izforge.izpack.util.AbstractUIHandler;
import com.izforge.izpack.util.CleanupClient;
import com.izforge.izpack.util.Housekeeper;
import com.redhat.installer.asconfiguration.ascontroller.ServerCommandsHelper;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public class ExistingInstallationBackupAction
extends PanelActionDialog
implements CleanupClient {
    private static AutomatedInstallData idata;
    private static String installPath;
    private static String backupPath;
    private Logger logger;
    private boolean loggerExists;
    private String backupDialogMessage;
    private String restoreDialogMessage;
    private AbstractUIHandler mHandler;

    @Override
    public void executeAction(AutomatedInstallData adata, AbstractUIHandler handler) {
        this.mHandler = handler;
        this.setLogger(ServerCommandsHelper.createLogger(this.getClass().getName()));
        Housekeeper.getInstance().registerForCleanup(this);
        installPath = idata.getVariable("INSTALL_PATH");
        backupPath = installPath + ".backup";
        File installPathFile = new File(installPath);
        File backupPathFile = new File(backupPath);
        if (backupPathFile.exists()) {
            try {
                FileUtils.deleteDirectory(backupPathFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (installPathFile.exists()) {
            this.startDialog(this.backupDialogMessage);
            this.recursiveDirectoryCopy(installPath, backupPath);
            this.stopDialog();
            idata.setVariable("backup.created", "true");
            if (this.loggerExists()) {
                this.logger.info(String.format(ExistingInstallationBackupAction.idata.langpack.getString("ExistingInstallationBackupAction.backup.created"), installPath, backupPath));
            }
        }
        this.closeLogHandlers();
    }

    @Override
    public void cleanUp() {
        boolean wasAborted;
        File backupFolder = new File(backupPath);
        File newlyInstalledFolder = new File(installPath);
        String aborted = idata.getVariable("install.aborted");
        boolean bl = wasAborted = aborted != null ? Boolean.parseBoolean(aborted) : false;
        if (backupFolder.exists() && (!ExistingInstallationBackupAction.idata.installSuccess || wasAborted)) {
            this.startDialog(this.restoreDialogMessage);
            if (newlyInstalledFolder.exists()) {
                try {
                    String relativeLogsDir = File.separator + "installation";
                    File fileLogDirs = new File(installPath + relativeLogsDir);
                    File backupFolderLogsDir = new File(backupFolder.getAbsolutePath() + relativeLogsDir);
                    if (!backupFolderLogsDir.exists() && !backupFolderLogsDir.mkdir()) {
                        this.logger.warning(String.format(ExistingInstallationBackupAction.idata.langpack.getString("directory.creation.failed"), backupFolderLogsDir.toString()));
                    }
                    if (fileLogDirs.isDirectory() && fileLogDirs.exists()) {
                        FileUtils.copyDirectory(fileLogDirs, backupFolderLogsDir);
                    }
                    FileUtils.deleteDirectory(newlyInstalledFolder);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.recursiveDirectoryCopy(backupPath, installPath);
            this.stopDialog();
            if (this.loggerExists()) {
                this.logger.info(String.format(ExistingInstallationBackupAction.idata.langpack.getString("ExistingInstallationBackupAction.restore.success"), backupPath, installPath));
            }
        }
        if (backupFolder.exists()) {
            try {
                FileUtils.deleteDirectory(backupFolder);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void recursiveDirectoryCopy(String rootPath, String rootDestPath) {
        LinkedList<File> files = new LinkedList<File>();
        File root = new File(rootPath);
        files.add(root);
        while (!files.isEmpty()) {
            File current = (File)files.remove();
            File backup = new File(current.getPath().replace(rootPath, rootDestPath));
            if (current.isDirectory()) {
                boolean success;
                File[] listFiles = current.listFiles();
                if (listFiles != null) {
                    Collections.addAll(files, listFiles);
                }
                if (!(success = backup.mkdir()) && this.loggerExists()) {
                    this.logger.warning(String.format(ExistingInstallationBackupAction.idata.langpack.getString("ExistingInstallationBackupAction.directory.creation.failure"), backup.getAbsolutePath()));
                }
            }
            this.copyRetainingPermissions(current, backup);
        }
    }

    private void closeLogHandlers() {
        if (this.loggerExists()) {
            for (Handler h : this.logger.getHandlers()) {
                h.close();
                this.logger.removeHandler(h);
            }
        }
    }

    private void copyRetainingPermissions(File source, File dest) {
        boolean exec = source.canExecute();
        boolean read = source.canRead();
        boolean write = source.canWrite();
        try {
            if (source.isDirectory()) {
                FileUtils.forceMkdir(dest);
            } else {
                FileUtils.copyFile(source, dest, true);
            }
            boolean execResult = dest.setExecutable(exec);
            boolean readResult = dest.setReadable(read);
            boolean writeResult = dest.setWritable(write);
            if (!(execResult && readResult && writeResult || !this.loggerExists())) {
                this.logger.info(String.format(ExistingInstallationBackupAction.idata.langpack.getString("ExistingInstallationBackupAction.retain.permission.error"), source.getAbsolutePath()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setLogger(Logger logger2) {
        this.logger = logger2;
        if (logger2 != null) {
            this.loggerExists = true;
        }
    }

    private boolean loggerExists() {
        return this.loggerExists;
    }

    @Override
    public void initialize(PanelActionConfiguration configuration) {
        if (idata == null) {
            idata = AutomatedInstallData.getInstance();
        }
        this.backupDialogMessage = ExistingInstallationBackupAction.idata.langpack.getString("ExistingInstallationBackupAction.backup.dialog.title");
        this.restoreDialogMessage = ExistingInstallationBackupAction.idata.langpack.getString("ExistingInstallationBackupAction.restore.dialog.title");
    }
}

