/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.layering.action;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionConfiguration;
import com.izforge.izpack.util.AbstractUIHandler;
import com.redhat.installer.layering.PreExistingConfigurationConstants;
import java.io.File;
import java.io.IOException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public abstract class PreExistingSetter
implements PanelAction {
    protected AutomatedInstallData idata;

    @Override
    public void executeAction(AutomatedInstallData idata, AbstractUIHandler handler) {
        File descFile;
        String path;
        this.idata = idata;
        boolean freshInstall = Boolean.parseBoolean(idata.getVariable("eap.needs.install"));
        this.resetDefaults();
        if (freshInstall) {
            this.resetDefaults();
            return;
        }
        Document doc = null;
        for (String descriptor : PreExistingConfigurationConstants.standaloneDescriptors) {
            path = idata.getInstallPath() + "/standalone/configuration/" + descriptor;
            descFile = new File(path);
            if (!descFile.exists()) continue;
            try {
                doc = Jsoup.parse(descFile, "UTF-8", "");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.setDefaults(descriptor, doc);
        }
        for (String descriptor : PreExistingConfigurationConstants.domainDescriptors) {
            path = idata.getInstallPath() + "/domain/configuration/" + descriptor;
            descFile = new File(path);
            if (!descFile.exists()) continue;
            try {
                doc = Jsoup.parse(descFile, "UTF-8", "");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.setDefaults(descriptor, doc);
        }
    }

    protected abstract void setDefaults(String var1, Document var2);

    protected abstract void resetDefaults();

    @Override
    public void initialize(PanelActionConfiguration configuration) {
    }
}

