/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.layering.action;

import com.redhat.installer.layering.PreExistingConfigurationConstants;
import com.redhat.installer.layering.action.PreExistingSetter;
import java.util.HashSet;
import java.util.Set;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

public class SetCollisionsDefault
extends PreExistingSetter {
    private Set<String> collidingExtensions = new HashSet<String>();
    private Set<String> collidingSubsystems = new HashSet<String>();
    private Set<String> collidingInfinispan = new HashSet<String>();
    private Set<String> collidingDatasources = new HashSet<String>();
    private Set<String> collidingSecurityDomains = new HashSet<String>();

    @Override
    protected void setDefaults(String xml, Document doc) {
        for (String module : this.collidingExtensions) {
            Elements elements = doc.select(String.format("extensions > extension[module=%s]", module));
            if (elements.isEmpty()) continue;
            this.idata.setVariable(xml + "." + module + ".extension.exists", "true");
        }
        for (String xmlns : this.collidingSubsystems) {
            if (!this.hasCollisions(doc, String.format("profile > subsystem[xmlns=%s]", xmlns))) continue;
            this.idata.setVariable(xml + "." + xmlns + ".subsystem.exists", "true");
        }
        for (String name : this.collidingInfinispan) {
            if (!this.hasCollisions(doc, String.format("cache-container[name=%s]", name))) continue;
            this.idata.setVariable(xml + "." + name + ".infinispan.exists", "true");
        }
        for (String name : this.collidingSecurityDomains) {
            if (!this.hasCollisions(doc, String.format("security-domains > security-domain[name=%s]", name))) continue;
            this.idata.setVariable(xml + "." + name + ".security-domain.exists", "true");
        }
        for (String name : this.collidingDatasources) {
            if (!this.hasCollisions(doc, String.format("datasources > datasource[pool-name=%s]", name))) continue;
            this.idata.setVariable(xml + "." + name + ".datasource.exists", "true");
        }
    }

    @Override
    protected void resetDefaults() {
        this.init();
        for (String xml : PreExistingConfigurationConstants.standaloneDescriptors) {
            this.idata.setVariable(xml + ".vault.preexisting", "false");
            for (String extension : this.collidingExtensions) {
                this.idata.setVariable(xml + "." + extension + ".extension.exists", "false");
            }
            for (String subsystem : this.collidingSubsystems) {
                this.idata.setVariable(xml + "." + subsystem + ".subsystem.exists", "false");
            }
            for (String infinispan : this.collidingInfinispan) {
                this.idata.setVariable(xml + "." + infinispan + ".infinispan.exists", "false");
            }
            for (String datasource : this.collidingDatasources) {
                this.idata.setVariable(xml + "." + datasource + ".datasource.exists", "false");
            }
            for (String securitydomain : this.collidingSecurityDomains) {
                this.idata.setVariable(xml + "." + securitydomain + ".security-domain.exists", "false");
            }
        }
    }

    private boolean hasCollisions(Document doc, String query) {
        Elements elements = doc.select(query);
        return !elements.isEmpty();
    }

    private void addAll(String[] source, Set<String> set) {
        for (String s : source) {
            set.add(s);
        }
    }

    private void init() {
        String extensions = this.idata.getVariable("colliding.extensions");
        String infinispan = this.idata.getVariable("colliding.infinispanCaches");
        String datasources = this.idata.getVariable("colliding.datasources");
        String security = this.idata.getVariable("colliding.securityDomains");
        String subsystems = this.idata.getVariable("colliding.subsystems");
        if (extensions != null) {
            this.addAll(extensions.split(","), this.collidingExtensions);
        }
        if (infinispan != null) {
            this.addAll(infinispan.split(","), this.collidingInfinispan);
        }
        if (datasources != null) {
            this.addAll(datasources.split(","), this.collidingDatasources);
        }
        if (security != null) {
            this.addAll(security.split(","), this.collidingSecurityDomains);
        }
        if (subsystems != null) {
            this.addAll(subsystems.split(","), this.collidingSubsystems);
        }
    }
}

