/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.layering.action;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIHandler;
import com.redhat.installer.layering.action.PreExistingSetter;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.jsoup.nodes.Document;

public class SetFswAdminUser
extends PreExistingSetter {
    @Override
    public void executeAction(AutomatedInstallData idata, AbstractUIHandler handler) {
        this.idata = idata;
        boolean needInstall = Boolean.parseBoolean(idata.getVariable("eap.needs.install"));
        this.resetDefaults();
        if (needInstall) {
            return;
        }
        String userPath = idata.getInstallPath() + "/standalone/configuration/application-users.properties";
        String rolePath = idata.getInstallPath() + "/standalone/configuration/application-roles.properties";
        PropertiesConfiguration applicationUsers = new PropertiesConfiguration();
        PropertiesConfiguration applicationRoles = new PropertiesConfiguration();
        try {
            applicationUsers.load(new File(userPath));
            applicationRoles.load(new File(rolePath));
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        Iterator<String> users = applicationUsers.getKeys();
        while (users.hasNext()) {
            String user = users.next();
            List<Object> rolesList = applicationRoles.getList(user);
            String roles = "";
            for (int i = 0; i < rolesList.size(); ++i) {
                roles = i == rolesList.size() - 1 ? roles + (String)rolesList.get(i) : roles + rolesList.get(i) + ",";
            }
            if (!roles.equals("overlorduser,admin.sramp,dev,qa,stage,prod,manager,arch,ba")) continue;
            idata.setVariable("fsw.user", user);
            idata.setVariable("fsw.user.exists", "true");
        }
    }

    @Override
    protected void setDefaults(String xml, Document doc) {
    }

    @Override
    protected void resetDefaults() {
        String defaultFswAdmin = this.idata.getVariable("fsw.user.default") != null ? this.idata.getVariable("fsw.user.default") : "fswAdmin";
        this.idata.setVariable("fsw.user", defaultFswAdmin);
        this.idata.setVariable("fsw.user.exists", "false");
    }
}

