/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.layering.action;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.redhat.installer.asconfiguration.jdbc.constant.JBossJDBCConstants;
import com.redhat.installer.asconfiguration.jdbc.validator.JDBCConnectionUtils;
import com.redhat.installer.layering.action.PreExistingSetter;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class SetJdbcDefaults
extends PreExistingSetter {
    private HashSet<File> moduleSubdirs = new HashSet();

    @Override
    protected void setDefaults(String xml, Document doc) {
        Elements drivers = doc.select("drivers > driver[name!=h2]");
        int foundCount = 0;
        for (Element driver : drivers) {
            URL[] moduleJarUrls;
            String driverName = driver.attr("name");
            String driverModule = driver.attr("module");
            String driverClass = null;
            String driverJarPath = null;
            for (URL jar : moduleJarUrls = JDBCConnectionUtils.convertToUrlArray(this.parseJarLocationFromModule(driverModule))) {
                driverClass = this.findExistingDriverClass(jar);
                try {
                    driverJarPath = driverClass != null ? new File(jar.toURI()).getPath() : null;
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            if (driverClass == null || driverJarPath == null) continue;
            String driverNameInternal = JBossJDBCConstants.classnameToJDBCMap.get(driverClass);
            this.idata.setVariable("jdbc.driver.preexisting", "true");
            this.idata.setVariable("jdbc.preexisting.driver." + xml + "." + ++foundCount + ".name", driverName);
            this.idata.setVariable("jdbc.preexisting.driver." + xml + "." + foundCount + ".name.internal", driverNameInternal);
            this.idata.setVariable("jdbc.preexisting.driver." + xml + "." + foundCount + ".classname", driverClass);
            this.idata.setVariable("jdbc.preexisting.driver." + xml + "." + foundCount + ".jar", driverJarPath);
            this.idata.setVariable("jdbc.driver." + xml + ".found.count", String.valueOf(foundCount));
        }
    }

    private String findExistingDriverClass(URL ... preExistingJDBCJars) {
        for (String driverClassname : JBossJDBCConstants.classnameList) {
            Class<?> driver = JDBCConnectionUtils.findDriverClass(driverClassname, preExistingJDBCJars);
            if (driver == null) continue;
            return driverClassname;
        }
        return null;
    }

    private Object[] parseJarLocationFromModule(String module) {
        ArrayList<File> fileList = new ArrayList<File>(1);
        for (File moduleSubdir : this.moduleSubdirs) {
            File searchDir = new File(moduleSubdir + "/" + module.replace(".", "/"), "/main/");
            if (!searchDir.exists()) continue;
            Iterator<File> jars = FileUtils.iterateFiles(searchDir, new String[]{"jar"}, false);
            while (jars.hasNext()) {
                fileList.add(jars.next());
            }
        }
        ArrayList<String> resultList = new ArrayList<String>();
        for (File file : fileList) {
            resultList.add(file.getPath());
        }
        return resultList.toArray();
    }

    @Override
    protected void resetDefaults() {
        this.idata.setVariable("jdbc.driver.preexisting", "false");
        this.moduleSubdirs.clear();
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String installPath = idata.getInstallPath();
        this.moduleSubdirs.add(new File(installPath + "/modules"));
        this.moduleSubdirs.add(new File(installPath + "/modules/system/layers/base/"));
        this.moduleSubdirs.add(new File(installPath + "/modules/system/layers/soa/"));
        this.moduleSubdirs.add(new File(installPath + "/modules/system/layers/sramp/"));
        this.moduleSubdirs.add(new File(installPath + "/modules/system/layers/dv/"));
        this.moduleSubdirs.add(new File(installPath + "/modules/system/layers/brms/"));
        this.moduleSubdirs.add(new File(installPath + "/modules/system/layers/bpms/"));
    }
}

