/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.layering.action;

import com.redhat.installer.layering.PreExistingConfigurationConstants;
import com.redhat.installer.layering.action.PreExistingSetter;
import java.util.HashSet;
import java.util.Set;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class SetLdapDefaults
extends PreExistingSetter {
    private Set<String> ldapRealmNames = new HashSet<String>();
    private Set<String> ldapConnNames = new HashSet<String>();

    @Override
    protected void setDefaults(String xml, Document doc) {
        Elements ldapRealms = doc.select("security-realm > authentication > ldap");
        Elements ldapConnections = doc.select("outbound-connections > ldap");
        if (ldapConnections.size() > 0) {
            this.idata.setVariable(xml + ".pre.existing.ldap", "true");
        } else {
            this.idata.setVariable(xml + ".pre.existing.ldap", "false");
        }
        for (Element realm : ldapRealms) {
            this.ldapRealmNames.add(realm.attr("name"));
        }
        for (Element conn : ldapConnections) {
            this.ldapConnNames.add(conn.attr("name"));
        }
    }

    @Override
    protected void resetDefaults() {
        this.idata.setVariable("ldap.preexisting.realm.names", "");
        this.idata.setVariable("ldap.preexisting.conn.names", "");
        for (String xml : PreExistingConfigurationConstants.descriptors) {
            this.idata.setVariable(xml + ".pre.existing.ldap", "false");
        }
        this.idata.setVariable("pre.existing.ldap", "false");
    }
}

