/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.layering.action;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionConfiguration;
import com.izforge.izpack.util.AbstractUIHandler;
import com.redhat.installer.layering.PreExistingConfigurationConstants;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class SetSecurityDomainDefault
implements PanelAction {
    private AutomatedInstallData idata;
    private Set<String> securityDomainNames = new HashSet<String>();

    @Override
    public void executeAction(AutomatedInstallData idata, AbstractUIHandler handler) {
        File descFile;
        String path;
        this.idata = idata;
        boolean needInstall = Boolean.parseBoolean(idata.getVariable("eap.needs.install"));
        this.resetDefaults();
        if (needInstall) {
            return;
        }
        Document doc = null;
        for (String descriptor : PreExistingConfigurationConstants.standaloneDescriptors) {
            path = idata.getInstallPath() + "/standalone/configuration/" + descriptor;
            descFile = new File(path);
            if (!descFile.exists()) continue;
            try {
                doc = Jsoup.parse(descFile, "UTF-8", "");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.setSecurityDomainDefaults(doc);
        }
        for (String descriptor : PreExistingConfigurationConstants.domainDescriptors) {
            path = idata.getInstallPath() + "/domain/configuration/" + descriptor;
            descFile = new File(path);
            if (!descFile.exists()) continue;
            try {
                doc = Jsoup.parse(descFile, "UTF-8", "");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.setSecurityDomainDefaults(doc);
        }
    }

    @Override
    public void initialize(PanelActionConfiguration configuration) {
    }

    private void setSecurityDomainDefaults(Document doc) {
        Elements securityDomains = doc.select("security-domains > security-domain");
        for (Element domain : securityDomains) {
            this.securityDomainNames.add(domain.attr("name"));
        }
    }

    private void resetDefaults() {
    }
}

