/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.layering.processpanel;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.izforge.izpack.util.Debug;
import com.redhat.installer.installation.processpanel.ArgumentParser;
import com.redhat.installer.layering.PreExistingConfigurationConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

public class PreExistingLdapSslHelper {
    private static HashMap<String, String> manInterfaceMap = new HashMap();
    private static HashMap<String, String> httpSocketMap = new HashMap();
    private static Elements ldapConnectionsBackup;
    private static ArgumentParser parser;
    private static AutomatedInstallData idata;
    private static Element serverIdentities;

    public static boolean run(AbstractUIProcessHandler handler, String[] args) {
        idata = AutomatedInstallData.getInstance();
        parser = new ArgumentParser();
        parser.parse(args);
        String path = idata.getVariable("INSTALL_PATH") + "/standalone/configuration/";
        for (String config : PreExistingConfigurationConstants.standaloneDescriptors) {
            File file = new File(path + config);
            try {
                FileInputStream stream = new FileInputStream(file);
                Document doc = Jsoup.parse(stream, "UTF-8", "", Parser.xmlParser());
                doc.outputSettings().prettyPrint(false);
                doc.outputSettings().escapeMode(Entities.EscapeMode.xhtml);
                if (parser.propertyIsTrue("remove")) {
                    if (idata.getVariable(config + ".pre.existing.ldap").equals("true")) {
                        PreExistingLdapSslHelper.removeLdap(doc);
                    }
                    if (idata.getVariable(config + ".pre.existing.ssl").equals("true")) {
                        PreExistingLdapSslHelper.removeSsl(doc);
                    }
                } else if (parser.propertyIsTrue("restore")) {
                    if (idata.getVariable(config + ".pre.existing.ldap").equals("true")) {
                        PreExistingLdapSslHelper.restoreLdap(doc);
                    }
                    if (idata.getVariable(config + ".pre.existing.ssl").equals("true")) {
                        PreExistingLdapSslHelper.restoreSsl(doc);
                    }
                }
                PrintWriter writer = new PrintWriter(file, "UTF-8");
                String cleanDoc = doc.toString().replace("implclass", "implClass");
                writer.write(cleanDoc);
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                Debug.log(config + " threw IOException when parsed by JSoup:");
                Debug.log(e.getMessage());
                return false;
            }
        }
        return true;
    }

    public static void removeLdap(Document doc) {
        Elements realms = doc.select("security-realms > security-realm");
        Elements ldapConnections = doc.select("outbound-connections > ldap");
        if (!ldapConnections.isEmpty()) {
            for (Element realm : realms) {
                Elements ldapRealms = realm.select("authentication > ldap");
                if (ldapRealms.isEmpty()) continue;
                String ldapRealmName = realm.attr("name");
                Elements managementInterfaces = doc.select("management-interfaces > *");
                int count = 0;
                for (Element manInterface : managementInterfaces) {
                    if (manInterface.attr("security-realm").equals(ldapRealmName)) {
                        manInterfaceMap.put(manInterface.tagName() + count, manInterface.attr("security-realm"));
                        manInterface.attr("security-realm", "ManagementRealm");
                    }
                    ++count;
                }
            }
            ldapConnectionsBackup = ldapConnections.clone();
            ldapConnections.remove();
        }
    }

    private static void removeSsl(Document doc) {
        Elements sslRealmIdentities = doc.select("security-realms > security-realm[name=ManagementRealm] > server-identities");
        if (sslRealmIdentities.size() == 1) {
            serverIdentities = sslRealmIdentities.first();
            sslRealmIdentities.remove();
            Elements httpInterfaces = doc.select("management-interfaces > http-interface");
            int count = 0;
            for (Element httpInterface : httpInterfaces) {
                Element socket = httpInterface.select("socket-binding").first();
                String binding = socket.hasAttr("https") ? "https=" + socket.attr("https") : "http=" + socket.attr("http");
                httpSocketMap.put(httpInterface.tagName() + count, binding);
                if (socket.hasAttr("https")) {
                    socket.removeAttr("https");
                    socket.attr("http", "management-http");
                }
                ++count;
            }
        }
    }

    private static void restoreSsl(Document doc) {
        Elements manRealm = doc.select("security-realms > security-realm[name=ManagementRealm]");
        if (manRealm.size() == 1) {
            manRealm.first().appendChild(serverIdentities);
        }
        Elements httpInterfaces = doc.select("management-interfaces > http-interface");
        int count = 0;
        for (Element httpInterface : httpInterfaces) {
            Element socket = httpInterface.select("socket-binding").first();
            socket.removeAttr("http");
            String[] binding = httpSocketMap.get(httpInterface.tagName() + count).split("=");
            socket.attr(binding[0], binding[1]);
            ++count;
        }
    }

    private static void restoreLdap(Document doc) {
        int count = 0;
        Elements managementInterfaces = doc.select("management-interfaces > *");
        for (Element manInterface : managementInterfaces) {
            if (manInterfaceMap.containsKey(manInterface.tagName() + count)) {
                manInterface.attr("security-realm", manInterfaceMap.get(manInterface.tagName() + count));
            }
            ++count;
        }
        Elements outboundConnections = doc.select("outbound-connections");
        if (outboundConnections.isEmpty()) {
            Elements manager = doc.select("management");
            manager.first().appendElement("outbound-connections");
            outboundConnections = doc.select("outbound-connections");
        }
        for (Element ldapConn : ldapConnectionsBackup) {
            outboundConnections.first().appendChild(ldapConn);
        }
    }

    public static HashMap<String, String> getManInterfaceMap() {
        return manInterfaceMap;
    }
}

