/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.layering.processpanel;

import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.layering.constant.ValidatorConstants;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class ProductLayersConfSetter {
    public static void run(AbstractUIProcessHandler handler, String[] args) throws IOException {
        String installPath;
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String basePath = installPath = idata.getVariable("INSTALL_PATH");
        String layersPath = basePath + ValidatorConstants.layersConfLoc;
        String productPath = basePath + ValidatorConstants.productConfLoc;
        String existingLayers = idata.getVariable("existing.layers.conf");
        String existingProduct = idata.getVariable("existing.product.conf");
        String newProduct = ProductLayersConfSetter.getNewProductString();
        String finalLayers = "";
        String finalProduct = "";
        finalProduct = ProductLayersConfSetter.getFinalProductString(existingProduct, newProduct);
        finalLayers = ProductLayersConfSetter.getFinalLayersString(existingLayers);
        ProductLayersConfSetter.writeConfFiles(basePath, finalProduct, finalLayers, productPath, layersPath);
    }

    private static String getNewProductString() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String product = "eap";
        List<Pack> installedPacks = idata.selectedPacks;
        for (Pack pack : installedPacks) {
            if (pack.id.startsWith("soa")) {
                product = "soa";
                break;
            }
            if (pack.id.startsWith("brms")) {
                product = "brms";
                continue;
            }
            if (pack.id.startsWith("bpms")) {
                product = "bpms";
                continue;
            }
            if (pack.id.startsWith("sramp")) {
                product = "sramp";
                continue;
            }
            if (!pack.id.startsWith("dv")) continue;
            product = "dv";
        }
        return product;
    }

    private static String getNewLayersString() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String layers = "";
        List<Pack> installedPacks = idata.selectedPacks;
        for (Pack pack : installedPacks) {
            if (!pack.id.startsWith("soa")) continue;
            layers = layers + "soa";
            break;
        }
        for (Pack pack : installedPacks) {
            if (!pack.id.startsWith("sramp")) continue;
            if (!layers.isEmpty()) {
                layers = layers + ",";
            }
            layers = layers + "sramp";
            break;
        }
        for (Pack pack : installedPacks) {
            if (pack.id.startsWith("brms")) {
                if (!layers.isEmpty()) {
                    layers = layers + ",";
                }
                layers = layers + "brms";
                break;
            }
            if (!pack.id.startsWith("bpms")) continue;
            if (!layers.isEmpty()) {
                layers = layers + ",";
            }
            layers = layers + "bpms";
            break;
        }
        for (Pack pack : installedPacks) {
            if (!pack.id.startsWith("dv")) continue;
            if (!layers.isEmpty()) {
                layers = layers + ",";
            }
            layers = layers + "dv";
            break;
        }
        return layers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeConfFiles(String basePath, String finalProduct, String finalLayers, String productPath, String layersPath) {
        File productConf = new File(productPath);
        File layersConf = new File(layersPath);
        BufferedWriter prodOut = null;
        try {
            prodOut = new BufferedWriter(new FileWriter(productConf));
            prodOut.write("#product.conf written by the platform installer\n");
            prodOut.write("slot=" + finalProduct);
            BufferedWriter layersOut = new BufferedWriter(new FileWriter(layersConf));
            layersOut.write("#layers.conf written by the platform installer\n");
            layersOut.write("layers=" + finalLayers);
            prodOut.close();
            layersOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (prodOut != null) {
                try {
                    prodOut.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static String getFinalLayersString(String existingLayers) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        StringBuilder finalLayers = new StringBuilder();
        String layers = "";
        String layersWord = idata.getVariable("layersWord");
        int i = 0;
        for (char bit : layersWord.toCharArray()) {
            String layer = ValidatorConstants.layers[i];
            if (bit == '1') {
                if ((layer.equals("soa") || layer.equals("sramp")) && !ProductLayersConfSetter.checkIfPackIsSelected(idata, layer) && !existingLayers.contains(layer)) {
                    ++i;
                    continue;
                }
            } else {
                ++i;
                continue;
            }
            finalLayers.append(ValidatorConstants.layers[i] + ",");
            ++i;
        }
        layers = finalLayers.length() > 0 ? finalLayers.substring(0, finalLayers.length() - 1) : finalLayers.toString();
        return layers;
    }

    private static boolean checkIfPackIsSelected(AutomatedInstallData idata, String layer) {
        if (idata.selectedPacks != null) {
            Iterator<Pack> iterator = idata.selectedPacks.iterator();
            while (iterator.hasNext()) {
                Pack selectedpack;
                Pack p = selectedpack = iterator.next();
                if (!p.id.contains(layer)) continue;
                return true;
            }
        }
        return false;
    }

    private static String getFinalProductString(String existingProduct, String newProduct) {
        if (newProduct.equals("soa") || existingProduct.equals("soa")) {
            return "soa";
        }
        if (existingProduct.equals("eap") || existingProduct.equals("sramp") && !newProduct.equals(existingProduct)) {
            return newProduct;
        }
        if ((existingProduct.equals("brms") || existingProduct.equals("bpms")) && newProduct.equals("sramp")) {
            return existingProduct;
        }
        return existingProduct;
    }
}

