/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.layering.processpanel;

import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class VersionTxtSetter {
    private static AutomatedInstallData idata = AutomatedInstallData.getInstance();
    private static final String VERSION = "/version.txt";
    private static final String LAYERS = "/modules/system/layers/";
    private static final String PRODUCT = "/org/jboss/as/product/";
    private static final String MANIFEST = "/dir/META-INF/MANIFEST.MF";

    public static void run(AbstractUIProcessHandler handler, String[] args) throws IOException {
        File f;
        String installPath = idata.getVariable("INSTALL_PATH");
        String versionSrcPath = installPath + LAYERS;
        String module = "";
        List<Pack> installedPacks = VersionTxtSetter.idata.selectedPacks;
        for (Pack pack : installedPacks) {
            if (pack.id.startsWith("soa")) {
                module = "soa";
                break;
            }
            if (pack.id.startsWith("sramp")) {
                module = "sramp";
                break;
            }
            if (pack.id.startsWith("dv")) {
                module = "dv";
                break;
            }
            if (pack.id.startsWith("bpms")) {
                module = "bpms";
                break;
            }
            if (!pack.id.startsWith("brms")) continue;
            module = "brms";
            break;
        }
        if (!(f = new File(versionSrcPath = versionSrcPath + module + PRODUCT)).exists()) {
            return;
        }
        versionSrcPath = versionSrcPath + module + MANIFEST;
        String versionDestPath = installPath + VERSION;
        String version = VersionTxtSetter.getVersion(versionSrcPath);
        VersionTxtSetter.writeVersion(versionDestPath, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVersion(String versionFile) throws IOException {
        String version = "\n";
        try (BufferedReader br = new BufferedReader(new FileReader(versionFile));){
            String line = br.readLine();
            version = version + line.substring(line.indexOf(32)).trim();
            version = version + " - Version ";
            line = br.readLine();
            version = version + line.substring(line.indexOf(32)).trim();
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeVersion(String versionFile, String content) {
        FileWriter fw = null;
        BufferedWriter bw = null;
        try {
            fw = new FileWriter(versionFile, true);
            bw = new BufferedWriter(fw);
            bw.write(content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

