/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.layering.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import java.io.File;

public class BusinessCentralExistsValidator
implements DataValidator {
    private static String BUSINESS_CENTRAL_WAR_PATH = "standalone/deployments/business-central.war";
    private String errorId;
    private String formattedMessage;
    private AutomatedInstallData idata;

    @Override
    public DataValidator.Status validateData(AutomatedInstallData adata) {
        this.idata = adata;
        String installPath = this.idata.getInstallPath();
        return this.businessCentralExistsAt(installPath);
    }

    private DataValidator.Status businessCentralExistsAt(String installPath) {
        File jbossHome = new File(installPath);
        File businessCentralWar = new File(jbossHome, BUSINESS_CENTRAL_WAR_PATH);
        if (businessCentralWar.exists()) {
            this.setErrorId("BusinessCentralExistsValidator.error");
            this.setFormattedMessage(String.format(this.idata.langpack.getString(this.getErrorMessageId()), jbossHome.toString()));
            return DataValidator.Status.ERROR;
        }
        return DataValidator.Status.OK;
    }

    @Override
    public String getErrorMessageId() {
        return this.errorId;
    }

    @Override
    public String getWarningMessageId() {
        return this.errorId;
    }

    private void setErrorId(String id) {
        this.errorId = id;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getFormattedMessage() {
        return this.formattedMessage;
    }

    private void setFormattedMessage(String message) {
        this.formattedMessage = message;
    }
}

