/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.layering.validator;

import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.util.Debug;
import com.redhat.installer.layering.constant.ValidatorConstants;
import com.redhat.installer.layering.util.PlatformUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EapExistsValidator
implements DataValidator {
    private static final String VERSION_REGEX = "\\b\\d\\.\\d\\.\\d[\\.\\w\\w\\d]*\\b";
    private static final String EAP_PACK_ID = "eap";
    private AutomatedInstallData idata;
    private String error;
    private String message;

    @Override
    public DataValidator.Status validateData(AutomatedInstallData idata) {
        this.idata = idata;
        switch (this.eapExists()) {
            case 0: {
                return DataValidator.Status.OK;
            }
            case 1: {
                return DataValidator.Status.WARNING;
            }
            case 2: {
                return DataValidator.Status.ERROR;
            }
        }
        return DataValidator.Status.ERROR;
    }

    private int eapExists() {
        boolean pathEmpty;
        String path = this.idata.getVariable("INSTALL_PATH") + File.separator;
        File selectedInstallPath = new File(path);
        this.idata.setVariable("existing.layers.conf", "");
        this.idata.setVariable("existing.product.conf", "");
        boolean bl = pathEmpty = selectedInstallPath.isDirectory() && selectedInstallPath.listFiles().length == 0;
        if (this.installsEap()) {
            if (!selectedInstallPath.exists() || pathEmpty) {
                this.setVariablesForNoEapFound();
                return 0;
            }
            if (selectedInstallPath.isFile()) {
                this.setErrorMessageId("EapExistsValidator.eap.folder.emptyFile");
                this.setMessage(String.format(this.idata.langpack.getString(this.error), selectedInstallPath.getAbsolutePath()));
                return 2;
            }
            if (selectedInstallPath.exists() && PlatformUtil.isWindows() && this.containsOnlyIzPackTempFiles(selectedInstallPath)) {
                this.setVariablesForNoEapFound();
                return 0;
            }
            if (selectedInstallPath.exists() && !pathEmpty && this.idata.getVariable("product.name").equals(EAP_PACK_ID)) {
                this.setErrorMessageId("EapExistsValidator.eap.folder.nonempty");
                this.setMessage(String.format(this.idata.langpack.getString(this.error), selectedInstallPath.getAbsolutePath()));
                return 2;
            }
        } else {
            if (selectedInstallPath.isFile()) {
                this.setErrorMessageId("EapExistsValidator.eap.folder.emptyFile");
                this.setMessage(String.format(this.idata.langpack.getString(this.error), selectedInstallPath.getAbsolutePath()));
                return 2;
            }
            if (selectedInstallPath.exists() && !pathEmpty && this.idata.getVariable("product.name").equals(EAP_PACK_ID)) {
                this.setErrorMessageId("EapExistsValidator.eap.folder.nonempty");
                this.setMessage(String.format(this.idata.langpack.getString(this.error), selectedInstallPath.getAbsolutePath()));
                return 2;
            }
        }
        boolean productExists = false;
        boolean layersExists = false;
        try {
            productExists = this.readFileAndSetVariable(selectedInstallPath.getAbsolutePath() + ValidatorConstants.productConfLoc, "existing.product.conf", this.idata, "slot");
            layersExists = this.readFileAndSetVariable(selectedInstallPath.getAbsolutePath() + ValidatorConstants.layersConfLoc, "existing.layers.conf", this.idata, "layers");
        }
        catch (IOException e) {
            Debug.log("IOException thrown while reading products and layers files.");
        }
        if (!productExists) {
            this.setErrorMessageId("EapExistsValidator.product.conf.missing");
            this.setMessage(String.format(this.idata.langpack.getString(this.getErrorMessageId()), selectedInstallPath));
            return 2;
        }
        if (!this.idata.getVariable("existing.product.conf").equals(EAP_PACK_ID) && !layersExists) {
            this.setErrorMessageId("EapExistsValidator.layers.conf.missing");
            this.setMessage(String.format(this.idata.langpack.getString(this.error), selectedInstallPath));
            return 2;
        }
        String[] missingFiles = this.findMissingEapFiles(selectedInstallPath.getAbsolutePath());
        if (missingFiles.length > 0) {
            String s = "";
            for (int i = 0; i < missingFiles.length; ++i) {
                s = i < missingFiles.length - 1 ? s + missingFiles[i] + ", " : s + missingFiles[i] + ".";
            }
            this.setErrorMessageId("EapExistsValidator.missing.core.files");
            this.setMessage(String.format(this.idata.langpack.getString(this.getErrorMessageId()), s));
            return 2;
        }
        String existingVersion = this.getExistingEapVersion(selectedInstallPath.getPath());
        if (existingVersion.isEmpty()) {
            return 2;
        }
        String supportedVersion = this.getSupportedEapVersion();
        int supportedVersionInt = this.convertVersionToInt(supportedVersion);
        int existingVersionInt = this.convertVersionToInt(existingVersion);
        if (existingVersionInt < supportedVersionInt) {
            this.setErrorMessageId("EapExistsValidator.version.unsupported");
            this.setMessage(String.format(this.idata.langpack.getString(this.getErrorMessageId()), selectedInstallPath, existingVersion, supportedVersion));
            return 2;
        }
        if (existingVersionInt > supportedVersionInt) {
            this.setErrorMessageId("EapExistsValidator.version.warning");
            this.setMessage(String.format(this.idata.langpack.getString(this.getErrorMessageId()), selectedInstallPath, existingVersion, supportedVersion));
            this.setVariablesForValidEapInstallation();
            return 1;
        }
        this.setErrorMessageId("EapExistsValidator.eap.found.warning");
        this.setMessage(String.format(this.idata.langpack.getString(this.getErrorMessageId()), selectedInstallPath));
        this.setVariablesForValidEapInstallation();
        return 0;
    }

    private void setNonEmptyErrorMessage(String absolutePath) {
        this.setErrorMessageId("EapExistsValidator.eap.folder.nonempty");
        this.setMessage(String.format(this.idata.langpack.getString(this.getErrorMessageId()), absolutePath));
    }

    private boolean isProductEap() {
        return this.idata.getVariable("product.name").equals(EAP_PACK_ID);
    }

    private boolean isEmptyInstallPath(File selectedInstallPath) {
        boolean exists = selectedInstallPath.exists();
        boolean isDirectory = selectedInstallPath.isDirectory();
        return exists && isDirectory && selectedInstallPath.listFiles().length == 0;
    }

    private void setVariablesForNoEapFound() {
        this.idata.setVariable("eap.needs.install", "true");
        this.idata.setVariable("existing.product.conf", EAP_PACK_ID);
        this.idata.addPackToSelected(EAP_PACK_ID);
        this.idata.setPackPreselected(EAP_PACK_ID, true);
    }

    private void setVariablesForValidEapInstallation() {
        this.idata.setVariable("eap.needs.install", "false");
        this.idata.removePackFromSelected(EAP_PACK_ID);
        this.idata.setPackPreselected(EAP_PACK_ID, false);
    }

    private boolean installsEap() {
        for (Pack p : this.idata.allPacks) {
            if (!p.id.equals(EAP_PACK_ID)) continue;
            return true;
        }
        return false;
    }

    private boolean containsOnlyIzPackTempFiles(File installPath) {
        boolean allTmp = true;
        for (File file : installPath.listFiles()) {
            if (file.getName().startsWith("izWrTe") && file.getPath().endsWith(".tmp")) continue;
            allTmp = false;
        }
        return allTmp;
    }

    private String[] findMissingEapFiles(String installFolder) {
        String pathToConfig;
        String[] requiredConfigs = this.idata.getVariable("product.name").equals("dv") ? ValidatorConstants.requiredStandalonConfigDV : ValidatorConstants.requiredStandalonConfig;
        String[] requiredScripts = System.getProperty("os.name").toLowerCase().startsWith("windows") ? ValidatorConstants.requiredScriptsWindows : ValidatorConstants.requiredScriptsUnix;
        String[] requiredDomainConfigs = ValidatorConstants.requiredDomainConfigNonEap;
        ArrayList<String> missingFiles = new ArrayList<String>();
        for (String config : requiredConfigs) {
            pathToConfig = installFolder + File.separator + ValidatorConstants.standaloneConfigFolder + config + ".xml";
            if (new File(pathToConfig).exists()) continue;
            missingFiles.add(ValidatorConstants.standaloneConfigFolder + config + ".xml");
        }
        for (String config : requiredDomainConfigs) {
            pathToConfig = installFolder + File.separator + ValidatorConstants.domainConfigFolderLoc + config + ".xml";
            if (new File(pathToConfig).exists()) continue;
            missingFiles.add(ValidatorConstants.domainConfigFolderLoc + config + ".xml");
        }
        for (String script : requiredScripts) {
            if (new File(installFolder + script).exists()) continue;
            missingFiles.add(script);
        }
        return missingFiles.toArray(new String[missingFiles.size()]);
    }

    private boolean readFileAndSetVariable(String path, String variable, AutomatedInstallData idata, String linePrefix) throws IOException {
        File file = new File(path);
        String value = this.getValidLineFromConf(file, linePrefix);
        if (value == null) {
            return false;
        }
        idata.setVariable(variable, value);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getValidLineFromConf(File file, String linePrefix) {
        if (file.exists()) {
            BufferedReader br = null;
            try {
                String line;
                br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                while ((line = br.readLine()) != null && line.startsWith("#")) {
                }
                if (line == null || br.readLine() != null || !line.startsWith(linePrefix)) {
                    br.close();
                    String string = null;
                    return string;
                }
                String[] split = line.split("=");
                if (split.length < 2) {
                    String string = null;
                    return string;
                }
                String string = split[1];
                return string;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    private String getExistingEapVersion(String selectedInstallPath) {
        File versionText = new File(selectedInstallPath + File.separator + "version.txt");
        String versionLine = "";
        String version = "";
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(versionText)));
            versionLine = br.readLine();
            br.close();
        }
        catch (IOException e) {
            Debug.log("IOException thrown while reading version.txt");
        }
        Pattern versionPattern = Pattern.compile(VERSION_REGEX);
        Matcher matcher = versionPattern.matcher(versionLine);
        if (!matcher.find()) {
            this.setErrorMessageId("EapExistsValidator.invalid.version");
            this.setMessage(String.format(this.idata.langpack.getString(this.getErrorMessageId()), selectedInstallPath));
        } else {
            version = matcher.group();
        }
        return version;
    }

    private String getSupportedEapVersion() {
        String majorVersion = this.idata.getVariable("eap.supported.version.major");
        String minorVersion = this.idata.getVariable("eap.supported.version.minor");
        String releaseVersion = this.idata.getVariable("eap.supported.version.micro");
        String releaseDesignation = this.idata.getVariable("eap.supported.version.designation");
        return majorVersion + "." + minorVersion + "." + releaseVersion + "." + releaseDesignation;
    }

    private int convertVersionToInt(String versionString) {
        String[] versionNumbers = versionString.split("\\.");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < versionNumbers.length - 1; ++i) {
            sb.append(versionNumbers[i]);
        }
        return Integer.parseInt(sb.toString());
    }

    private void setErrorMessageId(String e) {
        this.error = e;
    }

    @Override
    public String getErrorMessageId() {
        return this.error;
    }

    @Override
    public String getWarningMessageId() {
        return this.error;
    }

    private void setMessage(String string) {
        this.message = string;
    }

    @Override
    public boolean getDefaultAnswer() {
        return true;
    }

    @Override
    public String getFormattedMessage() {
        return this.message;
    }
}

