/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.layering.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.redhat.installer.layering.PreExistingConfigurationConstants;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

public class HornetQValidator
implements DataValidator {
    AutomatedInstallData idata;
    private String error = "";
    private String message;
    private final String standaloneHornetQQuery = "subsystem > hornetq-server:not([name])";
    private final String domainHornetQQuery = "profile:not([name=full]):not([name=full-ha]) > subsystem > hornetq-server:not([name])";
    private final String requiredHornetQConfigQuery = ":has(persistence-enabled:containsOwn(true)):has(journal-type:containsOwn(NIO)):has(journal-min-files:containsOwn(2)):has(connectors:has(netty-connector[name=netty][socket-binding=messaging])):has(connectors:has(netty-connector[name=netty-throughput][socket-binding=messaging-throughput]):has(param[key=batch-delay][value=50])):has(connectors:has(in-vm-connector[name=in-vm][server-id=0])):has(acceptors > netty-acceptor[name=netty][socket-binding=messaging]):has(acceptors:has(netty-acceptor[name=netty-throughput][socket-binding=messaging-throughput]):has(param[key=batch-delay][value=50])):has(param[key=direct-deliver][value=false]):has(acceptors:has(in-vm-acceptor[name=in-vm][server-id=0])):has(security-settings:has(security-setting[match=#]:has(permission[type=send][roles=guest]):has(permission[type=consume][roles=guest]):has(permission[type=createNonDurableQueue][roles=guest]):has(permission[type=deleteNonDurableQueue][roles=guest]))):has(address-settings:has(address-setting[match=#]:has(dead-letter-address:containsOwn(jms.queue.DLQ)):has(expiry-address:containsOwn(jms.queue.ExpiryQueue)):has(redelivery-delay:containsOwn(0)):has(max-size-bytes:contains(10485760)):has(message-counter-history-day-limit:contains(10)))):has(jms-connection-factories:has(connection-factory[name=InVmConnectionFactory]:has(connectors:has(connector-ref[connector-name=in-vm])):has(entries:has(entry[name=java:/ConnectionFactory]))):has(connection-factory[name=RemoteConnectionFactory]:has(connectors:has(connector-ref[connector-name=netty])):has(entries:has(entry[name=java:jboss/exported/jms/RemoteConnectionFactory]))):has(pooled-connection-factory[name=hornetq-ra]:has(transaction[mode=xa]):has(connectors:has(connector-ref[connector-name=in-vm])):has(entries:has(entry[name=java:/JmsXA]))))";

    @Override
    public DataValidator.Status validateData(AutomatedInstallData idata) {
        File descFile;
        String descPath;
        this.idata = idata;
        String warningMessage = "The following descriptors already contain hornetq-server configuration: %s. Errors could occur. Would you like to continue?";
        String errorMessage = "The following descriptors contain incompatible hornetq-server configuration: %s. Please choose a different installation path.";
        boolean eapNeedsInstall = Boolean.parseBoolean(idata.getVariable("eap.needs.install"));
        ArrayList<String> hornetQWarnings = new ArrayList<String>();
        ArrayList<String> hornetQErrors = new ArrayList<String>();
        if (eapNeedsInstall) {
            return DataValidator.Status.OK;
        }
        String basePath = idata.getVariable("INSTALL_PATH");
        block10: for (String descriptor : PreExistingConfigurationConstants.standaloneDescriptors) {
            descPath = basePath + "/standalone/configuration/" + descriptor;
            descFile = new File(descPath);
            if (!descFile.exists()) continue;
            switch (this.validateHornetQ(descriptor, descFile, "subsystem > hornetq-server:not([name])")) {
                case 0: {
                    continue block10;
                }
                case 1: {
                    hornetQWarnings.add(descriptor);
                    continue block10;
                }
                case 2: {
                    hornetQErrors.add(descriptor);
                }
            }
        }
        block11: for (String descriptor : PreExistingConfigurationConstants.domainDescriptors) {
            descPath = basePath + "/domain/configuration/" + descriptor;
            descFile = new File(descPath);
            if (!descFile.exists()) continue;
            switch (this.validateHornetQ(descriptor, descFile, "profile:not([name=full]):not([name=full-ha]) > subsystem > hornetq-server:not([name])")) {
                case 0: {
                    continue block11;
                }
                case 1: {
                    hornetQWarnings.add(descriptor);
                    continue block11;
                }
                case 2: {
                    hornetQErrors.add(descriptor);
                }
            }
        }
        if (!hornetQErrors.isEmpty()) {
            String errorDescs = "";
            for (String desc : hornetQErrors) {
                errorDescs = errorDescs + desc + " ";
            }
            this.setMessage(String.format(errorMessage, errorDescs.trim()));
            return DataValidator.Status.ERROR;
        }
        if (!hornetQWarnings.isEmpty()) {
            String warningDescs = "";
            for (String desc : hornetQWarnings) {
                warningDescs = warningDescs + desc + " ";
            }
            this.setMessage(String.format(warningMessage, warningDescs.trim()));
            return DataValidator.Status.WARNING;
        }
        return DataValidator.Status.OK;
    }

    private int validateHornetQ(String descriptor, File descFile, String baseQuery) {
        boolean status = false;
        try {
            Document doc = Jsoup.parse(descFile, "UTF-8", "");
            Elements defaultHornetQServer = doc.select(baseQuery);
            if (!defaultHornetQServer.isEmpty()) {
                Elements withRequiredConfig = defaultHornetQServer.select(":has(persistence-enabled:containsOwn(true)):has(journal-type:containsOwn(NIO)):has(journal-min-files:containsOwn(2)):has(connectors:has(netty-connector[name=netty][socket-binding=messaging])):has(connectors:has(netty-connector[name=netty-throughput][socket-binding=messaging-throughput]):has(param[key=batch-delay][value=50])):has(connectors:has(in-vm-connector[name=in-vm][server-id=0])):has(acceptors > netty-acceptor[name=netty][socket-binding=messaging]):has(acceptors:has(netty-acceptor[name=netty-throughput][socket-binding=messaging-throughput]):has(param[key=batch-delay][value=50])):has(param[key=direct-deliver][value=false]):has(acceptors:has(in-vm-acceptor[name=in-vm][server-id=0])):has(security-settings:has(security-setting[match=#]:has(permission[type=send][roles=guest]):has(permission[type=consume][roles=guest]):has(permission[type=createNonDurableQueue][roles=guest]):has(permission[type=deleteNonDurableQueue][roles=guest]))):has(address-settings:has(address-setting[match=#]:has(dead-letter-address:containsOwn(jms.queue.DLQ)):has(expiry-address:containsOwn(jms.queue.ExpiryQueue)):has(redelivery-delay:containsOwn(0)):has(max-size-bytes:contains(10485760)):has(message-counter-history-day-limit:contains(10)))):has(jms-connection-factories:has(connection-factory[name=InVmConnectionFactory]:has(connectors:has(connector-ref[connector-name=in-vm])):has(entries:has(entry[name=java:/ConnectionFactory]))):has(connection-factory[name=RemoteConnectionFactory]:has(connectors:has(connector-ref[connector-name=netty])):has(entries:has(entry[name=java:jboss/exported/jms/RemoteConnectionFactory]))):has(pooled-connection-factory[name=hornetq-ra]:has(transaction[mode=xa]):has(connectors:has(connector-ref[connector-name=in-vm])):has(entries:has(entry[name=java:/JmsXA]))))");
                if (!withRequiredConfig.isEmpty()) {
                    this.idata.setVariable(descriptor + ".hornetq.exists", "true");
                    return 1;
                }
                return 2;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return 0;
    }

    private void setError(String s) {
        this.error = s;
    }

    private void setMessage(String s) {
        this.message = s;
    }

    @Override
    public String getErrorMessageId() {
        return this.error;
    }

    @Override
    public String getWarningMessageId() {
        return this.error;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getFormattedMessage() {
        return this.message;
    }
}

