/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.layering.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.util.Debug;
import com.redhat.installer.layering.constant.ValidatorConstants;
import com.redhat.installer.layering.validator.TruthTable;

public class IsSupportedPlatformValidator
implements DataValidator {
    AutomatedInstallData idata;
    private String truthTableOutput = "11111100111111001100000011001000";
    TruthTable table = new TruthTable(this.truthTableOutput);
    String error;
    String message;

    @Override
    public DataValidator.Status validateData(AutomatedInstallData idata) {
        this.idata = idata;
        String existingProduct = idata.getVariable("existing.product.conf");
        String existingLayers = idata.getVariable("existing.layers.conf") != null ? idata.getVariable("existing.layers.conf") : "";
        boolean disableSramp = false;
        boolean disableSoa = false;
        String newLayers = idata.getVariable("new.layers.conf");
        String productReadableName = idata.getVariable("platform.readable.name");
        String invalidSRAMP = idata.langpack.getString("IsSupportedPlatformValidator.incompatibleSRAMP");
        Debug.trace("Layers Validator Truth Table: ");
        Debug.trace(this.table.toString());
        for (String newLayer : newLayers.split(",")) {
            if (newLayer.contains("soa") && existingLayers.contains("soa")) {
                disableSoa = true;
                continue;
            }
            if (newLayer.contains("sramp") && existingLayers.contains("sramp")) {
                if (newLayers.equals("sramp")) {
                    this.setMessage(invalidSRAMP);
                    return DataValidator.Status.WARNING;
                }
                disableSramp = true;
                continue;
            }
            if (existingLayers.contains(newLayer)) {
                this.setMessage(this.makeReadable(newLayer) + " can not be installed on top of an installation already containing " + this.makeReadable(existingLayers));
                return DataValidator.Status.ERROR;
            }
            if (!existingProduct.contains(newLayer)) continue;
            this.setMessage(this.makeReadable(newLayer) + " can not be installed on top of an " + this.makeReadable(existingProduct) + " installation.");
        }
        String layersWord = this.mapLayersToTruthTableRow(existingProduct, existingLayers, newLayers);
        idata.setVariable("layersWord", layersWord);
        if (this.table.getOutput(layersWord)) {
            String prods = "";
            if (disableSoa) {
                prods = "fsw";
                idata.setVariable("can.install.fsw", "false");
                idata.removePackFromSelected("soa-switchyard");
                idata.setPackSelectable("soa-switchyard", false);
                idata.setPackPreselected("soa-switchyard", false);
            } else {
                idata.setVariable("can.install.fsw", "true");
                idata.addPackToSelected("soa-switchyard");
                idata.setPackSelectable("soa-switchyard", true);
                idata.setPackPreselected("soa-switchyard", true);
            }
            if (disableSramp) {
                prods = prods.contains("fsw") ? "fsw and sramp" : "sramp";
                idata.setVariable("can.install.sramp", "false");
                idata.removePackFromSelected("sramp");
                idata.setPackSelectable("sramp", false);
                idata.setPackPreselected("sramp", false);
            } else {
                idata.setVariable("can.install.sramp", "true");
                idata.addPackToSelected("sramp");
                idata.setPackSelectable("sramp", true);
                idata.setPackPreselected("sramp", true);
            }
            if (disableSoa || disableSramp) {
                this.setMessage(String.format(idata.langpack.getString("IsSupportedPlatformValidator.incompatibleProduct"), prods, prods));
                return DataValidator.Status.WARNING;
            }
            return DataValidator.Status.OK;
        }
        this.setMessage(this.makeReadable(newLayers) + " can not be installed on top of an " + this.makeReadable(existingProduct) + " containing " + this.makeReadable(existingLayers) + ".");
        return DataValidator.Status.ERROR;
    }

    private String makeReadable(String layers) {
        return layers.replace("soa", "fsw").toUpperCase();
    }

    private String mapLayersToTruthTableRow(String existingProduct, String existingLayers, String newLayers) {
        StringBuilder sb = new StringBuilder();
        for (String prod : ValidatorConstants.layers) {
            if (existingProduct.contains(prod) || existingLayers.contains(prod) || newLayers.contains(prod)) {
                sb.append('1');
                continue;
            }
            sb.append('0');
        }
        Debug.trace("Existing prod/layer validation string: ");
        Debug.trace(sb.toString());
        return sb.toString();
    }

    private void setError(String string) {
        this.error = string;
    }

    private void setMessage(String string) {
        this.message = string;
    }

    @Override
    public String getErrorMessageId() {
        return this.error;
    }

    @Override
    public String getWarningMessageId() {
        return this.error;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getFormattedMessage() {
        return this.message;
    }
}

