/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.layering.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.redhat.installer.layering.PreExistingConfigurationConstants;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

public class IsValidVaultValidator
implements DataValidator {
    AutomatedInstallData idata;
    String resolvedKeystorePath;
    String errorMessageId;
    String formattedMessage;

    @Override
    public DataValidator.Status validateData(AutomatedInstallData adata) {
        this.idata = adata;
        return this.validatePreExistingVault();
    }

    private DataValidator.Status validatePreExistingVault() {
        String installPath = this.idata.getInstallPath();
        boolean vaultFound = false;
        for (String descriptor : PreExistingConfigurationConstants.descriptors) {
            String standaloneDescriptorPath = installPath + "/standalone/configuration/" + descriptor;
            String domainDescriptorPath = installPath + "/domain/configuration/" + descriptor;
            File standaloneDesc = new File(standaloneDescriptorPath);
            File domainDesc = new File(domainDescriptorPath);
            Document standaloneDoc = null;
            Document domainDoc = null;
            try {
                if (standaloneDesc.exists() && standaloneDesc.isFile()) {
                    standaloneDoc = Jsoup.parse(standaloneDesc, "UTF-8", "");
                    if (!this.vaultExists(standaloneDoc)) continue;
                    vaultFound = true;
                    if (!this.pathSubstitutionPerformed(standaloneDoc)) continue;
                    break;
                }
                if (!domainDesc.exists() || !domainDesc.isFile() || !this.vaultExists(domainDoc = Jsoup.parse(domainDesc, "UTF-8", ""))) continue;
                vaultFound = true;
                if (!this.pathSubstitutionPerformed(domainDoc)) continue;
                break;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!vaultFound) {
            return DataValidator.Status.OK;
        }
        File keystoreFile = new File(this.resolvedKeystorePath);
        if (!keystoreFile.exists() || !keystoreFile.isFile()) {
            this.setErrorMessageId("IsValidVaultValidator.missing.keystore");
            this.setFormattedMessage(this.idata.langpack.getString(this.getErrorMessageId()));
            return DataValidator.Status.ERROR;
        }
        this.idata.setVariable("vault.resolved.keystoreloc", this.resolvedKeystorePath);
        return DataValidator.Status.OK;
    }

    private boolean pathSubstitutionPerformed(Document doc) {
        if (this.vaultExists(doc)) {
            String keystorePath;
            this.resolvedKeystorePath = keystorePath = doc.select("vault > vault-option[name=KEYSTORE_URL]").first().attr("value");
            while (this.resolvedKeystorePath.matches(".*\\$\\{.*\\}.*")) {
                String oldPath = this.resolvedKeystorePath;
                this.resolvedKeystorePath = this.replaceProperties(this.resolvedKeystorePath, doc);
                if (!oldPath.equals(this.resolvedKeystorePath)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean vaultExists(Document doc) {
        return !doc.select("vault").isEmpty();
    }

    private String replaceProperties(String keystorePath, Document doc) {
        String returnValue = this.replaceServerProperties(keystorePath);
        if (returnValue.matches(".*\\$\\{.*\\}.*")) {
            return this.replaceUserProperties(returnValue, doc);
        }
        return returnValue;
    }

    private String replaceUserProperties(String inputString, Document doc) {
        String propertyName = this.getFirstProperty(inputString);
        String propertyValue = this.findPropertyInDescriptors(propertyName, doc);
        return propertyValue != null ? this.replaceProperty(inputString, propertyName, propertyValue) : inputString;
    }

    private String findPropertyInDescriptors(String propertyName, Document doc) {
        Elements propertyElements;
        File descriptorFile;
        for (String descriptor : PreExistingConfigurationConstants.standaloneDescriptors) {
            descriptorFile = new File(AutomatedInstallData.getInstance().getInstallPath() + "/standalone/configuration/" + descriptor);
            propertyElements = this.getPropertyWithName(descriptorFile, propertyName, doc);
            if (propertyElements.isEmpty()) continue;
            return propertyElements.last().attr("value");
        }
        for (String descriptor : PreExistingConfigurationConstants.domainDescriptors) {
            descriptorFile = new File(AutomatedInstallData.getInstance().getInstallPath() + "/domain/configuration/" + descriptor);
            propertyElements = this.getPropertyWithName(descriptorFile, propertyName, doc);
            if (propertyElements.isEmpty()) continue;
            return propertyElements.last().attr("value");
        }
        return null;
    }

    private Elements getPropertyWithName(File descriptorFile, String propertyName, Document document) {
        return document.select("system-properties > property[name=" + propertyName + "]");
    }

    private String replaceServerProperties(String keystorePath) {
        HashMap<String, String> standaloneMap = new HashMap<String, String>();
        standaloneMap.put("jboss.home.dir", this.idata.getInstallPath());
        standaloneMap.put("jboss.server.base.dir", (String)standaloneMap.get("jboss.home.dir") + "/standalone");
        standaloneMap.put("jboss.server.config.dir", (String)standaloneMap.get("jboss.server.base.dir") + "/configuration");
        standaloneMap.put("jboss.server.data.dir", (String)standaloneMap.get("jboss.server.base.dir") + "/data");
        standaloneMap.put("jboss.server.log.dir", (String)standaloneMap.get("jboss.server.base.dir") + "/log");
        String propertyName = this.getFirstProperty(keystorePath);
        if (standaloneMap.containsKey(propertyName)) {
            keystorePath = this.replaceProperty(keystorePath, propertyName, (String)standaloneMap.get(propertyName));
        }
        return keystorePath;
    }

    private String replaceProperty(String inputString, String propertyName, String propertyValue) {
        return inputString.replace("${" + propertyName + "}", propertyValue);
    }

    private String getFirstProperty(String inputString) {
        return inputString.substring(inputString.indexOf(123) + 1, inputString.indexOf(125));
    }

    @Override
    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    @Override
    public String getWarningMessageId() {
        return this.errorMessageId;
    }

    @Override
    public boolean getDefaultAnswer() {
        return true;
    }

    @Override
    public String getFormattedMessage() {
        return this.formattedMessage;
    }

    public void setErrorMessageId(String errorMessageId) {
        this.errorMessageId = errorMessageId;
    }

    public void setFormattedMessage(String formattedMessage) {
        this.formattedMessage = formattedMessage;
    }
}

