/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.layering.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.redhat.installer.asconfiguration.keystore.validator.KeystoreValidator;
import java.io.File;

public class PreExistingVaultValidator
extends KeystoreValidator {
    @Override
    protected DataValidator.Status performAdditionalChecksOnSuccess(String algorithm) {
        return DataValidator.Status.OK;
    }

    @Override
    protected boolean hasAdditionalChecksOnSuccess() {
        return false;
    }

    @Override
    public String getKeystorePath() {
        return AutomatedInstallData.getInstance().getVariable("vault.resolved.keystoreloc");
    }

    @Override
    public String getEncryptedDirPath() {
        return null;
    }

    @Override
    public String[] getSupportedFormats() {
        return AutomatedInstallData.getInstance().getVariable("preexisting.vault.allowed.keystore.types").split(",");
    }

    @Override
    public char[] getKeystorePassword() {
        return AutomatedInstallData.getInstance().getVariable("vault.keystorepwd").toCharArray();
    }

    @Override
    public boolean hasAdditionalChecksOnFail() {
        return true;
    }

    @Override
    public DataValidator.Status performAdditionalChecksOnFail(int result) {
        char[] pwd;
        String keystoreLoc = AutomatedInstallData.getInstance().getInstallPath() + File.separator + "vault.keystore";
        int newResult = PreExistingVaultValidator.isValidKeystore(keystoreLoc, pwd = this.getKeystorePassword(), this.getSupportedFormats());
        if (newResult == 0) {
            this.setVariable();
            return DataValidator.Status.OK;
        }
        return DataValidator.Status.WARNING;
    }

    @Override
    public void setVariable() {
        AutomatedInstallData.getInstance().setVariable("installVault", "true");
    }

    @Override
    public DataValidator.Status getFailureStatus() {
        return DataValidator.Status.ERROR;
    }

    @Override
    protected boolean getCondition() {
        return true;
    }
}

