/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.layering.validator;

import com.izforge.izpack.util.Debug;

public class TruthTable {
    String output;
    char[] outputVector;
    private Integer length;
    private Integer width;
    private Integer height;
    public static final char TRUE = '1';
    public static final char FALSE = '0';

    public TruthTable(String outputVector) {
        this.length = outputVector.length();
        if (this.length < 2) {
            Debug.log("Truth Table must have output length of at least 2");
            return;
        }
        this.output = outputVector;
        this.initDimensions();
        this.initOutputVector();
    }

    private void initDimensions() {
        double log = Math.log(this.length.doubleValue()) / Math.log(2.0);
        this.width = (int)Math.ceil(log);
        this.height = (int)Math.pow(2.0, this.width.intValue());
    }

    private void initOutputVector() {
        this.outputVector = new char[this.height.intValue()];
        char[] outputChars = this.output.toCharArray();
        for (int i = 0; i < this.height; ++i) {
            this.outputVector[i] = i > this.output.length() - 1 ? 48 : outputChars[i];
        }
    }

    private String makeRow(int rowNum) {
        StringBuilder sb = new StringBuilder();
        String vec = Integer.toBinaryString(rowNum);
        int padLength = this.width - vec.length();
        for (int i = 0; i < padLength; ++i) {
            sb.append("0");
        }
        sb.append(vec);
        return sb.toString();
    }

    public String getRow(int num) {
        if (num < this.height && num < this.outputVector.length) {
            return this.makeRow(num);
        }
        return "";
    }

    public boolean getOutput(String input) {
        int num = Integer.parseInt(input, 2);
        if (num < this.height && num < this.outputVector.length) {
            return this.outputVector[num] == '1';
        }
        return false;
    }

    public Integer getLength() {
        return this.length;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.height; ++i) {
            sb.append(this.makeRow(i) + "|" + this.outputVector[i] + System.getProperty("line.separator"));
        }
        return sb.toString();
    }
}

