/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.layering.validator.user;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.panels.SkippableDataValidator;
import com.izforge.izpack.util.Debug;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;

public abstract class DuplicateUserValidator
implements SkippableDataValidator {
    private final String[] REALMS = new String[]{"standalone", "domain"};
    private final String CONFIG_DIR = "configuration";
    private static final String error = "DuplicateUsername.errorMsg";
    private static final String warning = "DuplicateUsername.warningMsg";
    private String message;
    private static String skipMessage = "DuplicateUsername.warning.title";
    private static String overwrite = "usermsg.overwrite";
    private static String skip = "usermsg.skip";
    private static String cancel = "usermsg.cancel";
    private static String consoleOptions = "DuplicateUsername.console.options";
    private HashMap<String, HashSet<String>> usersMap = new HashMap();

    protected abstract String getUserVar();

    protected abstract String getCondVar();

    protected abstract String getFileName();

    protected abstract DataValidator.Status getConflictStatus();

    @Override
    public DataValidator.Status validateData(AutomatedInstallData idata) {
        String addUser;
        for (String realm : this.REALMS) {
            this.usersMap.put(realm, new HashSet());
        }
        String userFile = this.getFileName();
        String userVar = this.getUserVar();
        String user = idata.getVariable(userVar);
        String addCondVar = this.getCondVar();
        DataValidator.Status conflictStatus = this.getConflictStatus();
        if (addCondVar != null && (addUser = idata.getVariable(addCondVar)) != null && addUser.equals("false")) {
            idata.setVariable("add.new.user", "false");
            return DataValidator.Status.OK;
        }
        for (String realm : this.REALMS) {
            String filePath = this.getPath(realm, idata, userFile);
            if (!this.readExistingUsers(realm, filePath) || !this.usersMap.get(realm).contains(user)) continue;
            if (conflictStatus == DataValidator.Status.ERROR) {
                this.message = String.format(idata.langpack.getString(error), realm, user);
            }
            if (conflictStatus == DataValidator.Status.WARNING) {
                this.message = String.format(idata.langpack.getString(warning), user);
            }
            if (conflictStatus == DataValidator.Status.SKIP) {
                this.message = String.format(idata.langpack.getString(warning), user);
            }
            return conflictStatus;
        }
        this.doExtraWork();
        return DataValidator.Status.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readExistingUsers(String realm, String filePath) {
        FileReader reader = null;
        BufferedReader in = null;
        try {
            String line;
            reader = new FileReader(filePath);
            in = new BufferedReader(reader);
            while ((line = in.readLine()) != null) {
                if (line.startsWith("#") || !line.contains("=")) continue;
                String username = line.substring(0, line.indexOf(61));
                this.usersMap.get(realm).add(username);
            }
            in.close();
            reader.close();
        }
        catch (FileNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    private String getPath(String realm, AutomatedInstallData idata, String fileName) {
        String rootDir = idata.getInstallPath();
        String filePath = rootDir + File.separator + realm + File.separator + "configuration" + File.separator + fileName;
        return filePath;
    }

    @Override
    public String getErrorMessageId() {
        return error;
    }

    @Override
    public String getFormattedMessage() {
        return this.message;
    }

    @Override
    public String getWarningMessageId() {
        return warning;
    }

    @Override
    public boolean getDefaultAnswer() {
        return true;
    }

    @Override
    public int getDefaultChoice() {
        return 1;
    }

    @Override
    public boolean skipActions(AutomatedInstallData idata, int userChoice) {
        boolean returnValue = false;
        if (userChoice == 0) {
            idata.setVariable("add.new.user", "true");
            returnValue = true;
            Debug.trace("... but user decided to go on!");
        } else if (userChoice == 1) {
            idata.setVariable("add.new.user", "false");
            returnValue = true;
            Debug.trace("... but user decided to go on!");
        } else {
            returnValue = false;
            Debug.trace("... and the user decided to stop.");
        }
        return returnValue;
    }

    @Override
    public String[] getSkipOptionLabels(AutomatedInstallData idata) {
        return new String[]{idata.langpack.getString(overwrite), idata.langpack.getString(skip), idata.langpack.getString(cancel)};
    }

    @Override
    public String getSkipMessageId() {
        return skipMessage;
    }

    @Override
    public String getConsoleOptionsId() {
        return consoleOptions;
    }

    protected void doExtraWork() {
    }
}

