/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.logging;

import com.izforge.izpack.event.SimpleInstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.izforge.izpack.util.CleanupClient;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import com.redhat.installer.installation.util.InstallationUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Properties;
import java.util.Set;

public class LogIzPackVars
extends SimpleInstallerListener
implements CleanupClient {
    private static AutomatedInstallData idata;
    private static final String LOG_FILE_VAR = "installation.logfile";
    private static final String DEFAULT_FILE = "defaultInstallLog.txt";
    private static PrintStream logPrintStream;
    private static File logFile;
    private static AbstractUIProcessHandler mHandler;

    public static void run(AbstractUIProcessHandler handler, String[] args) {
        mHandler = handler;
        LogIzPackVars.initializeStaticVariables();
        LogIzPackVars.writeIzPackVariablesToLog();
        ProcessPanelHelper.printToPanel(handler, LogIzPackVars.idata.langpack.getString("LogIzPackVars.message") + " " + logFile.getAbsolutePath(), false);
        logPrintStream.close();
    }

    private static void initializeStaticVariables() {
        idata = AutomatedInstallData.getInstance();
        LogIzPackVars.setLogFile();
        logPrintStream = new PrintStream(LogIzPackVars.getLogFileStream());
    }

    private static void setLogFile() {
        String installLogPath = idata.getVariable(LOG_FILE_VAR);
        if (installLogPath != null) {
            logFile = new File(idata.getInstallPath() + "/" + installLogPath);
            File logFileParent = logFile.getParentFile();
            if (!logFileParent.exists()) {
                logFileParent.mkdirs();
            }
        } else {
            logFile = new File(idata.getInstallPath() + "/" + DEFAULT_FILE);
        }
    }

    private static FileOutputStream getLogFileStream() {
        FileOutputStream returnStream = null;
        try {
            returnStream = new FileOutputStream(logFile.getAbsoluteFile());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        InstallationUtilities.addFileToCleanupList(logFile.getAbsolutePath());
        return returnStream;
    }

    private static void writeIzPackVariablesToLog() {
        Properties allVars = idata.getVariables();
        Set<Object> keys = allVars.keySet();
        for (Object key : keys) {
            String realKey = (String)key;
            String realValue = (String)allVars.get(key);
            if (realKey.toLowerCase().contains("password") || realKey.toLowerCase().contains("pwd") || realKey.toLowerCase().contains("pass")) continue;
            if (realKey.toLowerCase().contains("system_sun_java_command")) {
                logPrintStream.println(realKey + " = " + LogIzPackVars.obfuscateCmdLineVariablePasswords(realValue));
                continue;
            }
            logPrintStream.println(realKey + " = " + realValue);
        }
        logPrintStream.close();
    }

    public static String obfuscateCmdLineVariablePasswords(String values) {
        String reg = "((P|p)(assword|wd)=)(.*?)(,|$)";
        String ret = values.replaceAll(reg, "$1********$5");
        return ret;
    }

    @Override
    public void cleanUp() {
        logPrintStream.close();
    }
}

