/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.password.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;

public class SharedPasswordValidator
implements DataValidator {
    private String message;
    private String error;

    @Override
    public DataValidator.Status validateData(AutomatedInstallData idata) {
        String samePasswordCheck = idata.getVariable("use.same.password");
        if (samePasswordCheck.equals("true")) {
            String password = idata.getVariable("adminPassword");
            String conditions = idata.getVariable("SharedPasswordValidator.conditions");
            String usernameIDs = idata.getVariable("SharedPasswordValidator.usernameIDs");
            String[] conditionList = conditions.split(",");
            String[] usernameIDList = usernameIDs.split(",");
            for (int i = 0; i < usernameIDList.length; ++i) {
                String condition = conditionList[i];
                String usernameID = usernameIDList[i];
                String username = idata.getVariable(usernameID);
                if (!idata.getRules().isConditionTrue(condition) || !password.equals(username)) continue;
                String usernameLabel = idata.langpack.getString(usernameID);
                this.setError("SharedPasswordValidator.match");
                this.setMessage(String.format(idata.langpack.getString(this.getErrorMessageId()), usernameLabel, username));
                return DataValidator.Status.ERROR;
            }
        }
        return DataValidator.Status.OK;
    }

    private void setError(String string) {
        this.error = string;
    }

    private void setMessage(String string) {
        this.message = string;
    }

    @Override
    public String getErrorMessageId() {
        return this.error;
    }

    @Override
    public String getWarningMessageId() {
        return "";
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getFormattedMessage() {
        return this.message;
    }
}

