/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.ports.utils;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.Debug;
import com.redhat.installer.asconfiguration.ports.utils.PortUtils;
import java.io.File;
import java.io.IOException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class PortReader {
    public static int getManagementPort(String path) {
        Document document;
        try {
            document = PortReader.loadXMLFile(path);
        }
        catch (IOException e) {
            Debug.trace(e);
            return 0;
        }
        if (path.contains("domain")) {
            return PortReader.getDomainManagementPort(document);
        }
        return PortReader.getStandaloneManagementPort(document);
    }

    private static Document loadXMLFile(String path) throws IOException {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        File file = new File(idata.getInstallPath(), path);
        Document document = Jsoup.parse(file, null);
        return document;
    }

    private static int getStandaloneManagementPort(Document document) {
        Element offsetElement = (Element)document.select("socket-binding-group").get(0);
        String offsetStr = offsetElement.attr("port-offset");
        int offset = PortUtils.getPort(offsetStr);
        Elements portElements = document.select("socket-binding");
        String portStr = "9990";
        for (Element element : portElements) {
            if (!element.hasAttr("port")) continue;
            portStr = element.attr("port");
            break;
        }
        int port = PortUtils.getPort(portStr);
        return offset + port;
    }

    private static int getDomainManagementPort(Document document) {
        Elements managementElements = document.select("native-interface");
        for (Element element : managementElements) {
            for (Element child : element.getElementsByTag("socket")) {
                if (!child.hasAttr("port")) continue;
                return PortUtils.getPort(child.attr("port"));
            }
        }
        return 9990;
    }
}

