/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.postinstall.processpanel;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.asconfiguration.ascontroller.ServerManager;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class BrowserLauncher {
    private static AbstractUIProcessHandler mHandler;

    public static void run(AbstractUIProcessHandler handler, String[] args) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        mHandler = handler;
        String browserLaunch = idata.langpack.getString("postinstall.processpanel.browserLaunch");
        String browserLaunchAbort = idata.langpack.getString("postinstall.processpanel.browserLaunchAbort");
        String link = ServerManager.getURL() + ServerManager.getManagementConsolePort();
        if (ServerManager.isServerUp()) {
            handler.logOutput(browserLaunch, false);
            LaunchBrowser br = new LaunchBrowser();
            br.exec(link);
        } else {
            handler.logOutput(browserLaunchAbort, false);
        }
    }

    private static class LaunchBrowser {
        private LaunchBrowser() {
        }

        private void exec(String url) {
            try {
                this.openURI(new URI(url));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }

        private void openURI(URI uri) {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                if (desktop.isSupported(Desktop.Action.BROWSE)) {
                    try {
                        desktop.browse(uri);
                        mHandler.logOutput("Browser Launched", false);
                    }
                    catch (IOException e) {
                        if (LaunchBrowser.openFallbackFailed(uri)) {
                            mHandler.logOutput("Cannot Open Browser! - BROWSE action does not support the URI", true);
                        }
                    }
                } else if (LaunchBrowser.openFallbackFailed(uri)) {
                    mHandler.logOutput("Cannot Open Browser! - BROWSE action not supported", true);
                }
            } else if (LaunchBrowser.openFallbackFailed(uri)) {
                mHandler.logOutput("Cannot Open Browser! - Desktop not supported", true);
            }
        }

        private static boolean openFallbackFailed(URI uri) {
            String os = System.getProperty("os.name");
            Runtime runtime = Runtime.getRuntime();
            String url = uri.toString();
            try {
                if (os.startsWith("Windows")) {
                    runtime.exec("rundll32 url.dll,FileProtocolHandler " + url);
                    mHandler.logOutput("Browser Launched via fallback Windows-specific call", false);
                } else if (os.startsWith("Mac OS")) {
                    Class.forName("com.apple.eio.FileManager").getDeclaredMethod("openURL", String.class).invoke(null, url);
                    mHandler.logOutput("Browser Launched via fallback Mac OS-specific call", false);
                } else {
                    String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape", "conkeror", "midori", "kazehakase"};
                    String browser = null;
                    for (String b : browsers) {
                        if (browser != null || Runtime.getRuntime().exec(new String[]{"which", b}).getInputStream().read() == -1) continue;
                        browser = b;
                        runtime.exec(new String[]{browser, url});
                        mHandler.logOutput("Browser Launched via fallback Linux/Unix call", false);
                    }
                    if (browser == null) {
                        runtime.exec(new String[]{"xdg-open", url});
                        mHandler.logOutput("Browser Launched via fallback xdg-open call", false);
                    }
                }
            }
            catch (Exception e) {
                mHandler.logOutput("Cannot Open Browser! - Fallback Failed", true);
                return true;
            }
            return false;
        }
    }
}

