/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.remoting.AbstractOutboundConnectionService;
import org.jboss.as.remoting.ConnectorUtils;
import org.jboss.as.remoting.GenericOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.GenericOutboundConnectionService;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.logging.RemotingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.remoting3.Endpoint;
import org.wildfly.common.Assert;
import org.xnio.OptionMap;

class GenericOutboundConnectionAdd
extends AbstractAddStepHandler {
    static final GenericOutboundConnectionAdd INSTANCE = new GenericOutboundConnectionAdd();

    static ModelNode getAddOperation(String connectionName, String uri, PathAddress address) {
        Assert.checkNotNullParam("connectionName", connectionName);
        Assert.checkNotEmptyParam("connectionName", connectionName);
        Assert.checkNotNullParam("uri", uri);
        Assert.checkNotEmptyParam("uri", uri);
        ModelNode addOperation = new ModelNode();
        addOperation.get("operation").set("add");
        addOperation.get("address").set(address.toModelNode());
        addOperation.get("uri").set(uri);
        return addOperation;
    }

    private GenericOutboundConnectionAdd() {
        super(new AttributeDefinition[]{GenericOutboundConnectionResourceDefinition.URI});
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode fullModel = Resource.Tools.readModel((Resource)resource);
        this.installRuntimeService(context, operation, fullModel);
    }

    void installRuntimeService(OperationContext context, ModelNode operation, ModelNode fullModel) throws OperationFailedException {
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String connectionName = pathAddress.getLastElement().getValue();
        OptionMap connectionCreationOptions = ConnectorUtils.getOptions(context, fullModel.get("property"));
        URI uri = this.getDestinationURI(context, operation);
        GenericOutboundConnectionService outboundRemotingConnectionService = new GenericOutboundConnectionService(connectionName, uri, connectionCreationOptions);
        ServiceName serviceName = AbstractOutboundConnectionService.OUTBOUND_CONNECTION_BASE_SERVICE_NAME.append(connectionName);
        ServiceName aliasServiceName = GenericOutboundConnectionService.GENERIC_OUTBOUND_CONNECTION_BASE_SERVICE_NAME.append(connectionName);
        context.getServiceTarget().addService(serviceName, outboundRemotingConnectionService).addAliases(aliasServiceName).addDependency(RemotingServices.SUBSYSTEM_ENDPOINT, Endpoint.class, outboundRemotingConnectionService.getEndpointInjector()).install();
    }

    URI getDestinationURI(OperationContext context, ModelNode outboundConnection) throws OperationFailedException {
        String uri = GenericOutboundConnectionResourceDefinition.URI.resolveModelAttribute(context, outboundConnection).asString();
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw RemotingLogger.ROOT_LOGGER.couldNotCreateURI(uri, e.toString());
        }
    }
}

