/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.remoting.RemoteOutboundConnectionAdd;
import org.jboss.as.remoting.RemoteOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.RemoteOutboundConnectionService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

class RemoteOutboundConnectionWriteHandler
extends AbstractWriteAttributeHandler<Boolean> {
    static final RemoteOutboundConnectionWriteHandler INSTANCE = new RemoteOutboundConnectionWriteHandler();

    private RemoteOutboundConnectionWriteHandler() {
        super(RemoteOutboundConnectionResourceDefinition.ATTRIBUTE_DEFINITIONS);
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Boolean> handbackHolder) throws OperationFailedException {
        ModelNode model = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        boolean handback = this.applyModelToRuntime(context, operation, model);
        handbackHolder.setHandback((Object)handback);
        return handback;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Boolean handback) throws OperationFailedException {
        if (handback != null && !handback.booleanValue()) {
            ModelNode restored = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
            restored.get(attributeName).set(valueToRestore);
            this.applyModelToRuntime(context, operation, restored);
        }
    }

    private boolean applyModelToRuntime(OperationContext context, ModelNode operation, ModelNode fullModel) throws OperationFailedException {
        boolean reloadRequired = false;
        String connectionName = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        ServiceName serviceName = RemoteOutboundConnectionService.OUTBOUND_CONNECTION_BASE_SERVICE_NAME.append(connectionName);
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController<?> sc = registry.getService(serviceName);
        if (sc != null && sc.getState() == ServiceController.State.UP) {
            reloadRequired = true;
        } else {
            context.removeService(serviceName);
            RemoteOutboundConnectionAdd.INSTANCE.installRuntimeService(context, operation, fullModel);
        }
        return reloadRequired;
    }
}

