/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.remoting.Attribute;
import org.jboss.as.remoting.ConnectorCommon;
import org.jboss.as.remoting.ConnectorResource;
import org.jboss.as.remoting.Element;
import org.jboss.as.remoting.HttpConnectorResource;
import org.jboss.as.remoting.Namespace;
import org.jboss.as.remoting.PropertyResource;
import org.jboss.as.remoting.RemotingEndpointResource;
import org.jboss.as.remoting.RemotingSubsystemRootResource;
import org.jboss.as.remoting.SaslPolicyResource;
import org.jboss.as.remoting.SaslResource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class RemotingSubsystemXMLPersister
implements XMLStreamConstants,
XMLElementWriter<SubsystemMarshallingContext> {
    RemotingSubsystemXMLPersister() {
    }

    @Override
    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        ModelNode connector;
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode model = context.getModelNode();
        this.writeWorkerThreadPoolIfAttributesSet(writer, model);
        this.writeEndpointIfAttributesSet(writer, model);
        if (model.hasDefined("connector")) {
            connector = model.get("connector");
            for (String name : connector.keys()) {
                this.writeConnector(writer, connector.require(name), name);
            }
        }
        if (model.hasDefined("http-connector")) {
            connector = model.get("http-connector");
            for (String name : connector.keys()) {
                this.writeHttpConnector(writer, connector.require(name), name);
            }
        }
        if (model.hasDefined("outbound-connection") || model.hasDefined("remote-outbound-connection") || model.hasDefined("local-outbound-connection")) {
            String connectionName;
            writer.writeStartElement(Element.OUTBOUND_CONNECTIONS.getLocalName());
            if (model.hasDefined("outbound-connection")) {
                List<Property> outboundConnections = model.get("outbound-connection").asPropertyList();
                for (Property property : outboundConnections) {
                    connectionName = property.getName();
                    ModelNode genericOutboundConnectionModel = property.getValue();
                    this.writeOutboundConnection(writer, connectionName, genericOutboundConnectionModel);
                }
            }
            if (model.hasDefined("remote-outbound-connection")) {
                List<Property> remoteOutboundConnections = model.get("remote-outbound-connection").asPropertyList();
                for (Property property : remoteOutboundConnections) {
                    connectionName = property.getName();
                    ModelNode remoteOutboundConnectionModel = property.getValue();
                    this.writeRemoteOutboundConnection(writer, connectionName, remoteOutboundConnectionModel);
                }
            }
            if (model.hasDefined("local-outbound-connection")) {
                List<Property> localOutboundConnections = model.get("local-outbound-connection").asPropertyList();
                for (Property property : localOutboundConnections) {
                    connectionName = property.getName();
                    ModelNode localOutboundConnectionModel = property.getValue();
                    this.writeLocalOutboundConnection(writer, connectionName, localOutboundConnectionModel);
                }
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeWorkerThreadPoolIfAttributesSet(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (node.hasDefined("worker-read-threads") || node.hasDefined("worker-task-core-threads") || node.hasDefined("worker-task-keepalive") || node.hasDefined("worker-task-limit") || node.hasDefined("worker-task-max-threads") || node.hasDefined("worker-write-threads")) {
            writer.writeStartElement(Element.WORKER_THREAD_POOL.getLocalName());
            RemotingSubsystemRootResource.WORKER_READ_THREADS.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
            RemotingSubsystemRootResource.WORKER_TASK_CORE_THREADS.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
            RemotingSubsystemRootResource.WORKER_TASK_KEEPALIVE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
            RemotingSubsystemRootResource.WORKER_TASK_LIMIT.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
            RemotingSubsystemRootResource.WORKER_TASK_MAX_THREADS.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
            RemotingSubsystemRootResource.WORKER_WRITE_THREADS.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }

    private void writeEndpointIfAttributesSet(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        boolean defined = false;
        for (String adName : RemotingEndpointResource.ATTRIBUTES.keySet()) {
            if (!model.hasDefined(adName)) continue;
            defined = true;
            break;
        }
        if (defined) {
            writer.writeEmptyElement(RemotingEndpointResource.ENDPOINT_PATH.getValue());
            for (AttributeDefinition ad : RemotingEndpointResource.ATTRIBUTES.values()) {
                ad.getMarshaller().marshallAsAttribute(ad, model, true, (XMLStreamWriter)writer);
            }
        }
    }

    private void writeConnector(XMLExtendedStreamWriter writer, ModelNode node, String name) throws XMLStreamException {
        writer.writeStartElement(Element.CONNECTOR.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), name);
        ConnectorResource.SOCKET_BINDING.marshallAsAttribute(node, (XMLStreamWriter)writer);
        ConnectorResource.SSL_CONTEXT.marshallAsAttribute(node, (XMLStreamWriter)writer);
        if (node.hasDefined("security-realm")) {
            writer.writeAttribute(Attribute.SECURITY_REALM.getLocalName(), node.require("security-realm").asString());
        }
        ConnectorCommon.SERVER_NAME.marshallAsAttribute(node, (XMLStreamWriter)writer);
        ConnectorCommon.SASL_PROTOCOL.marshallAsAttribute(node, (XMLStreamWriter)writer);
        ConnectorResource.SASL_AUTHENTICATION_FACTORY.marshallAsAttribute(node, (XMLStreamWriter)writer);
        ConnectorResource.AUTHENTICATION_PROVIDER.marshallAsElement(node, (XMLStreamWriter)writer);
        if (node.hasDefined("property")) {
            this.writeProperties(writer, node.get("property"));
        }
        if (node.hasDefined("security") && node.get("security").hasDefined("sasl")) {
            this.writeSasl(writer, node.get("security", "sasl"));
        }
        writer.writeEndElement();
    }

    private void writeHttpConnector(XMLExtendedStreamWriter writer, ModelNode node, String name) throws XMLStreamException {
        writer.writeStartElement(Element.HTTP_CONNECTOR.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), name);
        HttpConnectorResource.CONNECTOR_REF.marshallAsAttribute(node, (XMLStreamWriter)writer);
        if (node.hasDefined("security-realm")) {
            HttpConnectorResource.SECURITY_REALM.marshallAsAttribute(node, (XMLStreamWriter)writer);
        }
        ConnectorCommon.SERVER_NAME.marshallAsAttribute(node, (XMLStreamWriter)writer);
        ConnectorCommon.SASL_PROTOCOL.marshallAsAttribute(node, (XMLStreamWriter)writer);
        HttpConnectorResource.SASL_AUTHENTICATION_FACTORY.marshallAsAttribute(node, (XMLStreamWriter)writer);
        HttpConnectorResource.AUTHENTICATION_PROVIDER.marshallAsElement(node, (XMLStreamWriter)writer);
        if (node.hasDefined("property")) {
            this.writeProperties(writer, node.get("property"));
        }
        if (node.hasDefined("security") && node.get("security").hasDefined("sasl")) {
            this.writeSasl(writer, node.get("security", "sasl"));
        }
        writer.writeEndElement();
    }

    private void writeProperties(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        writer.writeStartElement(Element.PROPERTIES.getLocalName());
        for (Property prop : node.asPropertyList()) {
            writer.writeStartElement(Element.PROPERTY.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), prop.getName());
            PropertyResource.VALUE.marshallAsAttribute(prop.getValue(), (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeSasl(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        writer.writeStartElement(Element.SASL.getLocalName());
        SaslResource.INCLUDE_MECHANISMS_ATTRIBUTE.marshallAsElement(node, (XMLStreamWriter)writer);
        SaslResource.QOP_ATTRIBUTE.marshallAsElement(node, (XMLStreamWriter)writer);
        SaslResource.STRENGTH_ATTRIBUTE.marshallAsElement(node, (XMLStreamWriter)writer);
        SaslResource.SERVER_AUTH_ATTRIBUTE.marshallAsElement(node, (XMLStreamWriter)writer);
        SaslResource.REUSE_SESSION_ATTRIBUTE.marshallAsElement(node, (XMLStreamWriter)writer);
        if (node.hasDefined("sasl-policy")) {
            this.writePolicy(writer, node.get("sasl-policy"));
        }
        if (node.hasDefined("property")) {
            this.writeProperties(writer, node.get("property"));
        }
        writer.writeEndElement();
    }

    private void writePolicy(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        writer.writeStartElement(Element.POLICY.getLocalName());
        ModelNode policy = node.get("policy");
        SaslPolicyResource.FORWARD_SECRECY.marshallAsElement(policy, (XMLStreamWriter)writer);
        SaslPolicyResource.NO_ACTIVE.marshallAsElement(policy, (XMLStreamWriter)writer);
        SaslPolicyResource.NO_ANONYMOUS.marshallAsElement(policy, (XMLStreamWriter)writer);
        SaslPolicyResource.NO_DICTIONARY.marshallAsElement(policy, (XMLStreamWriter)writer);
        SaslPolicyResource.NO_PLAIN_TEXT.marshallAsElement(policy, (XMLStreamWriter)writer);
        SaslPolicyResource.PASS_CREDENTIALS.marshallAsElement(policy, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeOutboundConnection(XMLExtendedStreamWriter writer, String connectionName, ModelNode model) throws XMLStreamException {
        writer.writeStartElement(Element.OUTBOUND_CONNECTION.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), connectionName);
        String uri = model.get("uri").asString();
        writer.writeAttribute(Attribute.URI.getLocalName(), uri);
        if (model.hasDefined("property")) {
            this.writeProperties(writer, model.get("property"));
        }
        writer.writeEndElement();
    }

    private void writeRemoteOutboundConnection(XMLExtendedStreamWriter writer, String connectionName, ModelNode model) throws XMLStreamException {
        writer.writeStartElement(Element.REMOTE_OUTBOUND_CONNECTION.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), connectionName);
        String outboundSocketRef = model.get("outbound-socket-binding-ref").asString();
        writer.writeAttribute(Attribute.OUTBOUND_SOCKET_BINDING_REF.getLocalName(), outboundSocketRef);
        if (model.hasDefined("username")) {
            writer.writeAttribute(Attribute.USERNAME.getLocalName(), model.require("username").asString());
        }
        if (model.hasDefined("security-realm")) {
            writer.writeAttribute(Attribute.SECURITY_REALM.getLocalName(), model.require("security-realm").asString());
        }
        if (model.hasDefined("protocol")) {
            writer.writeAttribute(Attribute.PROTOCOL.getLocalName(), model.require("protocol").asString());
        }
        if (model.hasDefined("authentication-context")) {
            writer.writeAttribute(Attribute.AUTHENTICATION_CONTEXT.getLocalName(), model.require("authentication-context").asString());
        }
        if (model.hasDefined("property")) {
            this.writeProperties(writer, model.get("property"));
        }
        writer.writeEndElement();
    }

    private void writeLocalOutboundConnection(XMLExtendedStreamWriter writer, String connectionName, ModelNode model) throws XMLStreamException {
        writer.writeStartElement(Element.LOCAL_OUTBOUND_CONNECTION.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), connectionName);
        String outboundSocketRef = model.get("outbound-socket-binding-ref").asString();
        writer.writeAttribute(Attribute.OUTBOUND_SOCKET_BINDING_REF.getLocalName(), outboundSocketRef);
        if (model.hasDefined("property")) {
            this.writeProperties(writer, model.get("property"));
        }
        writer.writeEndElement();
    }
}

