/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.security.Principal;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringAllowedValuesValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.security.SecurityDomainAdd;
import org.jboss.as.security.SecurityDomainReloadWriteHandler;
import org.jboss.as.security.SecurityExtension;
import org.jboss.as.security.logging.SecurityLogger;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.as.security.service.SecurityDomainService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.security.CacheableManager;
import org.jboss.security.SimplePrincipal;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;

class SecurityDomainResourceDefinition
extends SimpleResourceDefinition {
    static final String CACHE_CONTAINER_NAME = "security";
    static final String INFINISPAN_CACHE_TYPE = "infinispan";
    static final RuntimeCapability<Void> LEGACY_SECURITY_DOMAIN = RuntimeCapability.Builder.of((String)"org.wildfly.security.legacy-security-domain", (boolean)true).setServiceType(SecurityDomainContext.class).build();
    public static final SimpleAttributeDefinition CACHE_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cache-type", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"default", "infinispan"}))).build();
    private final boolean registerRuntimeOnly;
    private final List<AccessConstraintDefinition> accessConstraints;

    SecurityDomainResourceDefinition(boolean registerRuntimeOnly) {
        super(new SimpleResourceDefinition.Parameters(SecurityExtension.SECURITY_DOMAIN_PATH, (ResourceDescriptionResolver)SecurityExtension.getResourceDescriptionResolver("security-domain")).setAddHandler((OperationStepHandler)SecurityDomainAdd.INSTANCE).setRemoveHandler((OperationStepHandler)new ServiceRemoveStepHandler(SecurityDomainService.SERVICE_NAME, SecurityDomainAdd.INSTANCE){

            protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
                super.performRuntime(context, operation, model);
                if (context.isResourceServiceRestartAllowed()) {
                    String cacheType = SecurityDomainAdd.getAuthenticationCacheType(model);
                    String securityDomain = context.getCurrentAddressValue();
                    if (SecurityDomainResourceDefinition.INFINISPAN_CACHE_TYPE.equals(cacheType)) {
                        for (InfinispanCacheRequirement requirement : EnumSet.allOf(InfinispanCacheRequirement.class)) {
                            context.removeService(requirement.getServiceName(context, SecurityDomainResourceDefinition.CACHE_CONTAINER_NAME, securityDomain));
                        }
                    }
                }
            }
        }).setCapabilities(new RuntimeCapability[]{LEGACY_SECURITY_DOMAIN}));
        this.registerRuntimeOnly = registerRuntimeOnly;
        ApplicationTypeConfig atc = new ApplicationTypeConfig(CACHE_CONTAINER_NAME, "security-domain");
        ApplicationTypeAccessConstraintDefinition acd = new ApplicationTypeAccessConstraintDefinition(atc);
        this.accessConstraints = Arrays.asList(SensitiveTargetAccessConstraintDefinition.SECURITY_DOMAIN, acd);
        this.setDeprecated(SecurityExtension.DEPRECATED_SINCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)CACHE_TYPE, null, (OperationStepHandler)new SecurityDomainReloadWriteHandler(new AttributeDefinition[]{CACHE_TYPE}));
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (this.registerRuntimeOnly) {
            resourceRegistration.registerOperationHandler((OperationDefinition)ListCachePrincipals.DEFINITION, (OperationStepHandler)ListCachePrincipals.INSTANCE);
            resourceRegistration.registerOperationHandler((OperationDefinition)FlushOperation.DEFINITION, (OperationStepHandler)FlushOperation.INSTANCE);
        }
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }

    public static ServiceName getSecurityDomainServiceName(PathAddress pathAddress) {
        PathAddress domain = Util.getParentAddressByKey((PathAddress)pathAddress, (String)"security-domain");
        if (domain == null) {
            throw SecurityLogger.ROOT_LOGGER.addressDidNotContainSecurityDomain();
        }
        return SecurityDomainService.SERVICE_NAME.append(domain.getLastElement().getValue());
    }

    private static ServiceController<SecurityDomainContext> getSecurityDomainService(OperationContext context, String securityDomain) {
        return context.getServiceRegistry(false).getRequiredService(SecurityDomainService.SERVICE_NAME.append(securityDomain));
    }

    private static void waitForService(ServiceController<?> controller) throws OperationFailedException {
        if (controller.getState() == ServiceController.State.UP) {
            return;
        }
        StabilityMonitor monitor = new StabilityMonitor();
        monitor.addController(controller);
        try {
            monitor.awaitStability(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw SecurityLogger.ROOT_LOGGER.interruptedWaitingForSecurityDomain(controller.getName().getSimpleName());
        }
        finally {
            monitor.removeController(controller);
        }
        if (controller.getState() != ServiceController.State.UP) {
            throw SecurityLogger.ROOT_LOGGER.requiredSecurityDomainServiceNotAvailable(controller.getName().getSimpleName());
        }
    }

    static final class FlushOperation
    extends AbstractRuntimeOnlyHandler {
        static final FlushOperation INSTANCE = new FlushOperation();
        static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("flush-cache", (ResourceDescriptionResolver)SecurityExtension.getResourceDescriptionResolver("security-domain")).setEntryType(OperationEntry.EntryType.PUBLIC).setRuntimeOnly().addParameter((AttributeDefinition)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("principal", ModelType.STRING).setRequired(false)).build()).build();

        FlushOperation() {
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            ServiceController controller;
            ModelNode opAddr = operation.require("address");
            PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
            String securityDomain = address.getLastElement().getValue();
            String principal = null;
            if (operation.hasDefined("principal")) {
                principal = operation.get("principal").asString();
            }
            if ((controller = SecurityDomainResourceDefinition.getSecurityDomainService(context, securityDomain)) != null) {
                SecurityDomainResourceDefinition.waitForService(controller);
                SecurityDomainContext sdc = (SecurityDomainContext)controller.getValue();
                CacheableManager manager = (CacheableManager)((Object)sdc.getAuthenticationManager());
                if (principal != null) {
                    manager.flushCache(new SimplePrincipal(principal));
                } else {
                    manager.flushCache();
                }
            } else {
                throw SecurityLogger.ROOT_LOGGER.noAuthenticationCacheAvailable(securityDomain);
            }
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }
    }

    static class ListCachePrincipals
    extends AbstractRuntimeOnlyHandler {
        static final ListCachePrincipals INSTANCE = new ListCachePrincipals();
        static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("list-cached-principals", (ResourceDescriptionResolver)SecurityExtension.getResourceDescriptionResolver("list-cached-principals")).setReadOnly().setRuntimeOnly().setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).build();

        ListCachePrincipals() {
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode opAddr = operation.require("address");
            PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
            String securityDomain = address.getLastElement().getValue();
            ServiceController controller = SecurityDomainResourceDefinition.getSecurityDomainService(context, securityDomain);
            if (controller != null) {
                SecurityDomainResourceDefinition.waitForService(controller);
                SecurityDomainContext sdc = (SecurityDomainContext)controller.getValue();
                CacheableManager manager = (CacheableManager)((Object)sdc.getAuthenticationManager());
                Set cachedPrincipals = manager.getCachedKeys();
                ModelNode result = context.getResult();
                for (Principal principal : cachedPrincipals) {
                    result.add(principal.getName());
                }
                if (!result.isDefined()) {
                    result.setEmptyList();
                }
            } else {
                throw SecurityLogger.ROOT_LOGGER.noAuthenticationCacheAvailable(securityDomain);
            }
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }
    }
}

