/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.deployment;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.enterprise.concurrent.ContextService;
import org.jboss.as.ee.concurrent.handle.ContextHandleFactory;
import org.jboss.as.ee.concurrent.handle.ResetContextHandle;
import org.jboss.as.ee.concurrent.handle.SetupContextHandle;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.wildfly.security.manager.WildFlySecurityManager;

public class SecurityContextHandleFactory
implements ContextHandleFactory {
    public static final String NAME = "SECURITY";
    public static final SecurityContextHandleFactory INSTANCE = new SecurityContextHandleFactory();

    private SecurityContextHandleFactory() {
    }

    public SetupContextHandle saveContext(ContextService contextService, Map<String, String> contextObjectProperties) {
        return new SecuritySetupContextHandle();
    }

    public String getName() {
        return NAME;
    }

    public int getChainPriority() {
        return 300;
    }

    public void writeSetupContextHandle(SetupContextHandle contextHandle, ObjectOutputStream out) throws IOException {
        out.writeObject(contextHandle);
    }

    public SetupContextHandle readSetupContextHandle(ObjectInputStream in) throws IOException, ClassNotFoundException {
        return (SetupContextHandle)in.readObject();
    }

    private static class SecurityResetContextHandle
    implements ResetContextHandle {
        private final SecurityContext previous;

        private SecurityResetContextHandle(SecurityContext previous) {
            this.previous = previous;
        }

        public String getFactoryName() {
            return SecurityContextHandleFactory.NAME;
        }

        public void reset() {
            if (WildFlySecurityManager.isChecking()) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        this.resetSecurityContext();
                        return null;
                    }
                });
            } else {
                this.resetSecurityContext();
            }
        }

        private void resetSecurityContext() {
            SecurityContextAssociation.setSecurityContext(this.previous);
        }
    }

    private static class SecuritySetupContextHandle
    implements SetupContextHandle {
        private final SecurityContext securityContext = WildFlySecurityManager.isChecking() ? AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                return this.saveSecurityContext();
            }
        }) : this.saveSecurityContext();

        private SecuritySetupContextHandle() {
        }

        private SecurityContext saveSecurityContext() {
            return SecurityContextAssociation.getSecurityContext();
        }

        public String getFactoryName() {
            return SecurityContextHandleFactory.NAME;
        }

        public ResetContextHandle setup() throws IllegalStateException {
            SecurityContext previous = WildFlySecurityManager.isChecking() ? AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

                @Override
                public SecurityContext run() {
                    return this.setupSecurityContext();
                }
            }) : this.setupSecurityContext();
            return new SecurityResetContextHandle(previous);
        }

        private SecurityContext setupSecurityContext() {
            SecurityContext previous = SecurityContextAssociation.getSecurityContext();
            SecurityContextAssociation.setSecurityContext(this.securityContext);
            return previous;
        }
    }
}

