/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.elytron;

import java.security.Principal;
import java.security.acl.Group;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.as.security.logging.SecurityLogger;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.plugins.SimpleRoleGroup;
import org.jboss.security.mapping.MappingContext;
import org.jboss.security.mapping.MappingType;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;

public class SecurityDomainContextRealm
implements SecurityRealm {
    private SecurityDomainContext domainContext;
    private final boolean applyRoleMappers;

    public SecurityDomainContextRealm(SecurityDomainContext context, boolean applyRoleMappers) {
        this.domainContext = context;
        this.applyRoleMappers = applyRoleMappers;
    }

    @Override
    public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
        return new PicketBoxBasedIdentity(principal);
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
        return SupportLevel.UNSUPPORTED;
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
        return SupportLevel.UNSUPPORTED;
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        if (PasswordGuessEvidence.class.isAssignableFrom(evidenceType)) {
            return SupportLevel.SUPPORTED;
        }
        return SupportLevel.UNSUPPORTED;
    }

    private class PicketBoxBasedIdentity
    implements RealmIdentity {
        private final Principal principal;
        private Subject authenticatedSubject;

        private PicketBoxBasedIdentity(Principal principal) {
            this.principal = principal;
        }

        @Override
        public Principal getRealmIdentityPrincipal() {
            return this.principal;
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            return SecurityDomainContextRealm.this.getCredentialAcquireSupport(credentialType, algorithmName);
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return SecurityDomainContextRealm.this.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return null;
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return SecurityDomainContextRealm.this.getEvidenceVerifySupport(evidenceType, algorithmName);
        }

        @Override
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            boolean isValid;
            if (SecurityDomainContextRealm.this.domainContext == null || SecurityDomainContextRealm.this.domainContext.getAuthenticationManager() == null) {
                throw new RealmUnavailableException();
            }
            Subject jaasSubject = new Subject();
            Object jaasCredential = evidence;
            if (evidence instanceof PasswordGuessEvidence) {
                jaasCredential = ((PasswordGuessEvidence)evidence).getGuess();
            }
            if (isValid = SecurityDomainContextRealm.this.domainContext.getAuthenticationManager().isValid(this.principal, jaasCredential, jaasSubject)) {
                this.authenticatedSubject = jaasSubject;
            }
            return isValid;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return this.authenticatedSubject != null;
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            if (this.authenticatedSubject == null) {
                throw SecurityLogger.ROOT_LOGGER.unableToCreateAuthorizationIdentity();
            }
            Attributes attributes = null;
            Set<Principal> principals = this.authenticatedSubject.getPrincipals();
            if (principals != null) {
                for (Principal principal : principals) {
                    if (!(principal instanceof Group)) continue;
                    Set<String> values = this.processGroup((Group)principal);
                    if (attributes == null) {
                        attributes = new MapAttributes();
                    }
                    attributes.addAll(principal.getName(), values);
                }
            }
            if (attributes == null) {
                attributes = Attributes.EMPTY;
            }
            return AuthorizationIdentity.basicIdentity(attributes);
        }

        private Set<String> processGroup(Group group) {
            MappingContext<SimpleRoleGroup> mappingContext;
            HashSet<String> groupContents = new HashSet<String>();
            HashSet<Principal> groupPrincipals = new HashSet<Principal>();
            Enumeration enumeration = group.members();
            while (enumeration.hasMoreElements()) {
                groupPrincipals.add((Principal)enumeration.nextElement());
            }
            if (SecurityDomainContextRealm.this.applyRoleMappers && "Roles".equals(group.getName()) && SecurityDomainContextRealm.this.domainContext.getMappingManager() != null && (mappingContext = SecurityDomainContextRealm.this.domainContext.getMappingManager().getMappingContext(MappingType.ROLE.name())) != null && mappingContext.hasModules()) {
                SimpleRoleGroup roleGroup = new SimpleRoleGroup(groupPrincipals);
                HashMap<String, Object> contextMap = new HashMap<String, Object>();
                contextMap.put("Roles", roleGroup);
                if (this.principal != null) {
                    contextMap.put("Principal", this.principal);
                }
                mappingContext.performMapping(contextMap, roleGroup);
                for (Role role : roleGroup.getRoles()) {
                    groupContents.add(role.getRoleName());
                }
            }
            if (groupContents.isEmpty()) {
                for (Principal rolePrincipal : groupPrincipals) {
                    groupContents.add(rolePrincipal.getName());
                }
            }
            return groupContents;
        }
    }
}

